% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices_labeled.R
\name{value_choices}
\alias{value_choices}
\alias{value_choices.character}
\alias{value_choices.data.frame}
\title{Value labeling and filtering based on variable relationship}
\usage{
value_choices(data, var_choices, var_label = NULL, subset = NULL, sep = " - ")

\method{value_choices}{character}(data, var_choices, var_label = NULL, subset = NULL, sep = " - ")

\method{value_choices}{data.frame}(data, var_choices, var_label = NULL, subset = NULL, sep = " - ")
}
\arguments{
\item{data}{(\code{data.frame}, \code{character})
If \code{data.frame}, then data to extract labels from.
If \code{character}, then name of the dataset to extract data from once available.}

\item{var_choices}{(\code{character}, \code{delayed_variable_choices}) Choice of column names.}

\item{var_label}{(\code{character}) vector with labels column names.}

\item{subset}{(\code{character} or \code{function})
If \code{character}, vector with values to subset.
If \code{function}, then this function is used to determine the possible columns (e.g. all factor columns).
In this case, the function must take only single argument "data" and return a character vector.

See examples for more details.}

\item{sep}{(\code{character}) separator used in case of multiple column names.}
}
\value{
named character vector or \code{delayed_data} object.
}
\description{
Wrapper on \link{choices_labeled} to label variable values basing on other variable values.
}
\examples{
ADRS <- teal.data::rADRS
value_choices(ADRS, "PARAMCD", "PARAM", subset = c("BESRSPI", "INVET"))
value_choices(ADRS, c("PARAMCD", "ARMCD"), c("PARAM", "ARM"))
value_choices(ADRS, c("PARAMCD", "ARMCD"), c("PARAM", "ARM"),
  subset = c("BESRSPI - ARM A", "INVET - ARM A", "OVRINV - ARM A")
)
value_choices(ADRS, c("PARAMCD", "ARMCD"), c("PARAM", "ARM"), sep = " --- ")

# delayed version
value_choices("ADRS", c("PARAMCD", "ARMCD"), c("PARAM", "ARM"))

# functional subset
value_choices(ADRS, "PARAMCD", "PARAM", subset = function(data) {
  levels(data$PARAMCD)[1:2]
})
}
