% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_manifest.R
\name{ild_bundle}
\alias{ild_bundle}
\title{Bundle a result with a reproducibility manifest}
\usage{
ild_bundle(result, manifest = NULL, label = NULL)
}
\arguments{
\item{result}{Any object (e.g. fitted model, diagnostics list).}

\item{manifest}{List. Reproducibility manifest from [ild_manifest()].
If \code{NULL}, [ild_manifest()] is called with default arguments.}

\item{label}{Optional character. Short label for the run (e.g.
\code{"model_ar1"} or \code{"diagnostics"}).}
}
\value{
A list with elements \code{result}, \code{manifest}, \code{label},
  suitable for [saveRDS()].
}
\description{
Combines a result (e.g. a fit from [ild_lme()] or output from
[ild_diagnostics()]) with a manifest and optional label for one-shot
saving. Typical use: \code{saveRDS(ild_bundle(fit, label = "model_ar1"), "run.rds")}.
You can build a manifest with [ild_manifest()] and pass \code{scenario}
(e.g. from [ild_summary()]) and \code{seed} before bundling.
}
\examples{
dat <- ild_prepare(ild_simulate(seed = 1), "id", "time")
fit <- ild_lme(y ~ 1 + (1 | id), dat, ar1 = FALSE, warn_no_ar1 = FALSE)
b <- ild_bundle(fit, label = "ar1")
names(b)
b <- ild_bundle(fit, manifest = ild_manifest(seed = 1, scenario = list(n_obs = 50)), label = "run1")
}
