% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_check_lags.R
\name{ild_check_lags}
\alias{ild_check_lags}
\title{Check lag variable validity (gap-aware)}
\usage{
ild_check_lags(x, lag_vars = NULL, max_gap = NULL)
}
\arguments{
\item{x}{An ILD object (see [is_ild()]) that contains lag columns
(e.g. from [ild_lag()] with \code{mode = "gap_aware"}).}

\item{lag_vars}{Character vector of lag column names (e.g. \code{"y_lag1"}).
If \code{NULL}, attempts to detect columns ending in \code{_lag{n}}.}

\item{max_gap}{Numeric. Threshold used to define invalid (same units as
\code{.ild_time_num}). If \code{NULL}, uses \code{ild_meta(x)$ild_gap_threshold}.}
}
\value{
A data frame with one row per lag variable: \code{var}, \code{n_valid},
  \code{n_invalid}, \code{n_first} (rows that are first per person, so no lag),
  \code{n_total}, \code{pct_valid} (among rows that could have a lag, i.e. excluding first).
}
\description{
Given an ILD object and lag variable names, reports how many lagged
values are valid vs invalid (NA because the time distance to the
lagged row exceeded a threshold). Useful to audit lag columns before
modeling without re-specifying \code{max_gap}.
}
