% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_TNn}
\alias{calculate_TNn}
\title{Calculate monthly minimum value of daily minimum temperature (TNn)}
\usage{
calculate_TNn(
  df,
  frequency = "daily",
  time_col = NULL,
  tmin_col = NULL,
  temp_col = NULL,
  min_days = 20
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly"}

\item{time_col}{Name of the time column. For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmin_col}{Name of minimum temperature column (daily data)}

\item{temp_col}{Name of temperature column (for single temp or hourly)}

\item{min_days}{Minimum days per month for valid calculation (default: 20)}
}
\value{
A tibble with columns: year, month, TNn
}
\description{
Calculates the lowest daily minimum temperature for each month,
following ETCCDI definition TNn.
}
\examples{
# Daily data with minimum temperature
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmin = rnorm(1096, mean = 10, sd = 5)
)

calculate_TNn(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmin_col = "tmin"
)

# With custom minimum days per month
calculate_TNn(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmin_col = "tmin",
  min_days = 25
)
}
