% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-validation.R
\name{tidy_silhouette_analysis}
\alias{tidy_silhouette_analysis}
\title{Silhouette Analysis Across Multiple k Values}
\usage{
tidy_silhouette_analysis(
  data,
  max_k = 10,
  method = "kmeans",
  nstart = 25,
  dist_method = "euclidean",
  linkage_method = "average"
)
}
\arguments{
\item{data}{A data frame or tibble}

\item{max_k}{Maximum number of clusters to test (default: 10)}

\item{method}{Clustering method: "kmeans" (default) or "hclust"}

\item{nstart}{If kmeans, number of random starts (default: 25)}

\item{dist_method}{Distance metric (default: "euclidean")}

\item{linkage_method}{If hclust, linkage method (default: "average")}
}
\value{
A tibble with k and average silhouette widths
}
\description{
Silhouette Analysis Across Multiple k Values
}
