% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{tl_prepare_data}
\alias{tl_prepare_data}
\title{Data Preprocessing for tidylearn}
\usage{
tl_prepare_data(
  data,
  formula = NULL,
  impute_method = "mean",
  scale_method = "standardize",
  encode_categorical = TRUE,
  remove_zero_variance = TRUE,
  remove_correlated = FALSE,
  correlation_cutoff = 0.95
)
}
\arguments{
\item{data}{A data frame}

\item{formula}{Optional formula (for supervised learning)}

\item{impute_method}{Method for missing value imputation: "mean", "median", "mode", "knn"}

\item{scale_method}{Scaling method: "standardize", "normalize", "robust", "none"}

\item{encode_categorical}{Whether to encode categorical variables (default: TRUE)}

\item{remove_zero_variance}{Remove zero-variance features (default: TRUE)}

\item{remove_correlated}{Remove highly correlated features (default: FALSE)}

\item{correlation_cutoff}{Correlation threshold for removal (default: 0.95)}
}
\value{
A list containing processed data and preprocessing metadata
}
\description{
Unified preprocessing functions that work with both supervised and unsupervised workflows
Prepare Data for Machine Learning
}
\details{
Comprehensive preprocessing pipeline including imputation, scaling,
encoding, and feature engineering
}
\examples{
\donttest{
processed <- tl_prepare_data(iris, Species ~ ., scale_method = "standardize")
model <- tl_model(processed$data, Species ~ ., method = "logistic")
}
}
