% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_boolean.R
\name{answer_as_boolean}
\alias{answer_as_boolean}
\title{Make LLM answer as a boolean (TRUE or FALSE)}
\usage{
answer_as_boolean(
  prompt,
  true_definition = NULL,
  false_definition = NULL,
  add_instruction_to_prompt = TRUE
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{true_definition}{(optional) Definition of what would constitute TRUE.
This will be included in the instruction to the LLM. Should be a single string}

\item{false_definition}{(optional) Definition of what would constitute FALSE.
This will be included in the instruction to the LLM. Should be a single string}

\item{add_instruction_to_prompt}{(optional) Add instruction for replying
as a boolean to the prompt text. Set to FALSE for debugging if extractions/validations
are working as expected (without instruction the answer should fail the
validation function, initiating a retry)}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will ensure that the LLM response is a boolean
}
\description{
Make LLM answer as a boolean (TRUE or FALSE)
}
\examples{
\dontrun{
  "Are you a large language model?" |>
    answer_as_boolean() |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   Are you a large language model?
  #
  #   You must answer with only TRUE or FALSE (use no other characters).
  # --- Receiving response from LLM provider: ---
  #   TRUE
  # [1] TRUE
}
}
\seealso{
Other pre_built_prompt_wraps: 
\code{\link{add_image}()},
\code{\link{add_text}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_as_prompt_wraps: 
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()}
}
\concept{answer_as_prompt_wraps}
\concept{pre_built_prompt_wraps}
