% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_page_links.R
\name{tw_reset_wikipedia_page_links_cache}
\alias{tw_reset_wikipedia_page_links_cache}
\title{Reset Wikipedia page link cache}
\usage{
tw_reset_wikipedia_page_links_cache(
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  cache_connection = NULL,
  disconnect_db = TRUE,
  ask = TRUE
)
}
\arguments{
\item{language}{Two-letter language code used to define the Wikipedia version
to use. Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not set,
"en". If url given, this can be left empty.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{ask}{Logical, defaults to TRUE. If FALSE, and cache folder does not
exist, it just creates it without asking (useful for non-interactive
sessions).}
}
\value{
Nothing, used for its side effects.
}
\description{
Removes from cache the table where data typically gathered with
\code{\link[=tw_get_wikipedia_page_links]{tw_get_wikipedia_page_links()}} are stored.
}
\examples{
if (interactive()) {
  tw_reset_wikipedia_page_links_cache()
}
}
