% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\alias{compare.tna}
\alias{compare.matrix}
\title{Compare Two Matrices or TNA Models with Comprehensive Metrics}
\usage{
compare(x, ...)

\method{compare}{tna}(x, y, scaling = "none", measures = character(0), network = TRUE, ...)

\method{compare}{matrix}(x, y, scaling = "none", measures = character(0), network = TRUE, ...)
}
\arguments{
\item{x}{A \code{tna} object or a \code{matrix} of weights.}

\item{...}{Ignored.}

\item{y}{A \code{tna} object or a \code{matrix} of weights.}

\item{scaling}{A  \code{character} string naming a scaling method to
apply to the weights before comparing them. The supported options are:
\itemize{
\item \code{"none"}: No scaling is performed. The weights are used as is.
\item \code{"minmax"}: Performs min-max normalization, i.e., the minimum value is
subtracted and the differences are scaled by the range.
\item \code{"max"}: Max-normalization: the values are divided by the maximum value.
\item \code{"rank"}: Applies min-max normalization to the ranks of the weights
(computed with \code{ties.method = "average"}).
\item \code{"zscore"}: Computes the standard score, i.e. the mean weight is
subtracted and the differences are scaled by the standard deviation.
\item \code{"robust"}: Computes the robust z-score, i.e. the median weight is
subtracted and the differences are scaled by the median absolute deviation
(using \link[stats:mad]{stats::mad}).
\item \code{"log"}: Simply the natural logarithm of the weights.
\item \code{"log1p"}: As above, but adds 1 to the values before taking the logarithm.
Useful for scenarios with zero weights.
\item \code{"softmax"}: Performs softmax normalization.
\item \code{"quantile"}: Uses the empirical quantiles of the weights
via \link[stats:ecdf]{stats::ecdf}.
}}

\item{measures}{A \code{character} vector indicating which centrality
measures should be computed. See \code{\link[=centralities]{centralities()}} for the
available measures. No measures are included by default.}

\item{network}{A \code{logical} value indicating whether network metrics should
be included in the comparison. The default is \code{TRUE}.}
}
\value{
A \code{tna_comparison} object, which is a \code{list} containing the
following elements:
\itemize{
\item \code{matrices}: A \code{list} containing the scaled matrices of the input \code{tna}
objects or the scaled inputs themselves in the case of matrices.
\item \code{difference_matrix}: A \code{matrix} of differences \code{x - y}.
\item \code{edge_metrics}: A \code{data.frame} of edge-level metrics about the differences.
\item \code{summary_metrics}: A \code{data.frame} of summary metrics of the differences
across all edges.
\item \code{network_metrics}: A \code{data.frame} of network metrics for both \code{x} and \code{y}.
\item \code{centrality_differences}: A \code{data.frame} of differences in centrality
measures computes from \code{x} and \code{y}.
\item \code{centrality_correlations}: A \code{numeric} vector of correlations of the
centrality measures between \code{x} and \code{y}.
}
}
\description{
Various distances, measures of dissimilarity and similarity, correlations
and other metrics are computed to compare the models. Optionally, the weight
matrices of the models can be scaled before comparison. The resulting object
can be used to produce heatmap plots and scatterplots to further illustrate
the differences.
}
\examples{
# Comparing TNA models
model_x <- tna(group_regulation[1:200, ])
model_y <- tna(group_regulation[1001:1200, ])
comp1 <- compare(model_x, model_y)

# Comparing matrices
mat_x <- model_x$weights
mat_y <- model_y$weights
comp2 <- compare(mat_x, mat_y)

# Comparing a matrix to a TNA model
comp3 <- compare(mat_x, model_y)

}
\seealso{
Model comparison functions
\code{\link{compare.group_tna}()},
\code{\link{compare_sequences}()},
\code{\link{plot.tna_comparison}()},
\code{\link{plot.tna_sequence_comparison}()},
\code{\link{plot_compare}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{print.tna_comparison}()},
\code{\link{print.tna_sequence_comparison}()}
}
\concept{comparison}
