% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{permutation_test.group_tna}
\alias{permutation_test.group_tna}
\title{Compare Networks using a Permutation Test}
\usage{
\method{permutation_test}{group_tna}(
  x,
  groups,
  adjust = "none",
  iter = 1000,
  paired = FALSE,
  level = 0.05,
  measures = character(0),
  consecutive = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{group_tna} object}

\item{groups}{An \code{integer} vector or a \code{character} vector of group indices
or names, respectively, defining which groups to compare. When not provided,
all pairs are compared (the default).}

\item{adjust}{A \code{character} string for the method to adjust p-values with
for multiple comparisons. The default is \code{"none"} for no adjustment.
See the \code{method} argument of \code{\link[stats:p.adjust]{stats::p.adjust()}} for details and available
adjustment methods.}

\item{iter}{An \code{integer} giving the number of permutations to perform.
The default is 1000.}

\item{paired}{A \code{logical} value. If \code{TRUE}, perform paired permutation tests;
if \code{FALSE}, perform unpaired tests. The default is \code{FALSE}.}

\item{level}{A \code{numeric} value giving the significance level for the
permutation tests. The default is 0.05.}

\item{measures}{A \code{character} vector of centrality measures to test.
See \code{\link[=centralities]{centralities()}} for a list of available centrality measures.}

\item{consecutive}{A \code{logical} value. If \code{FALSE} (the default), all pairwise
comparisons are performed in lexicographic order with respect to the order
of the groups. If \code{TRUE}, only comparisons between consecutive pairs
of groups are performed.}

\item{...}{Additional arguments passed to \code{\link[=centralities]{centralities()}}.}
}
\description{
Test edge weight differences between all pairs or a subset of pairs of
a \code{group_tna} object. See \code{\link[=permutation_test.tna]{permutation_test.tna()}} for more details.
}
\examples{
model <- group_model(engagement_mmm)
# Small number of iterations for CRAN
permutation_test(model, iter = 20)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
