% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_atan2}
\alias{torch_atan2}
\title{Atan2}
\usage{
torch_atan2(self, other)
}
\arguments{
\item{self}{(Tensor) the first input tensor}

\item{other}{(Tensor) the second input tensor}
}
\description{
Atan2
}
\section{atan2(input, other, out=NULL) -> Tensor }{


Element-wise arctangent of \eqn{\mbox{input}_{i} / \mbox{other}_{i}}
with consideration of the quadrant. Returns a new tensor with the signed angles
in radians between vector \eqn{(\mbox{other}_{i}, \mbox{input}_{i})}
and vector \eqn{(1, 0)}. (Note that \eqn{\mbox{other}_{i}}, the second
parameter, is the x-coordinate, while \eqn{\mbox{input}_{i}}, the first
parameter, is the y-coordinate.)

The shapes of \code{input} and \code{other} must be
broadcastable .
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4))
a
torch_atan2(a, torch_randn(c(4)))
}
}
