\encoding{utf8}
\name{tost.rrp}
\alias{Test for equivalence of relative risk and unity in paired binary data}
\alias{tost.rrp}
\concept{paired z tests for proportion-equivalence}
\concept{Two One-Sided Tests}
\title{Test for equivalence of relative risk and unity in paired binary data}
\description{
 \loadmathjax
 Performs two one-sided \emph{z} tests for equivalence of marginal probabilities in binary data following Tang, Tang, and Chan, 2003}
\usage{
tost.rrp(
  x=NA, y=NA, 
  delta0       = 1, 
  deltaupper   = NA, 
  exact.chisq  = FALSE,
  conf.level   = 0.95, 
  treatment1   = "", 
  treatment2   = "", 
  outcome      = "", 
  nooutcome    = "",
  relevance    = TRUE)
}
\arguments{
 \item{x}{a (non-empty) vector of binary data values of equal length to \code{y}. The order of observations in \code{x} is assumed to correspond to the order of observations in \code{y} (i.e. \code{x} and \code{y} are paired.}
 \item{y}{a (non-empty) vector of binary data values of equal length to \code{x}. The order of observations in \code{y} is assumed to correspond to the order of observations in \code{x} (i.e. \code{x} and \code{y} are paired.}
 \item{delta0}{a required real value between 0 and 1 defining the lower threshold of an equivalence interval around RR=1. The upper boundary is \code{1/delta0}, unless \code{deltaupper} is used to define an assymetric upper interval. The default value is \code{delta0=1} which is not a useful value.}
 \item{deltaupper}{an optional value greater than 1 which is other than \code{1/delta0} and which creates a geometrically asymmetric equivalence interval.}
 \item{exact.chisq}{indicates that Fisher’s exact p-value will be used for the positivist test (i.e. for McNemar's \mjeqn{\chi^2}{chi-sq} test). This probability is calculated as \mjeqn{2\sum_{i=0}^{\min{b,c}}\text{Binomial}\left(n=b+c, k=i, p=0.5\right)}{two times the sum, from \emph{i} = 0 to min(\emph{b}, \emph{c}), of the binomial probability for \emph{n} = \emph{b} + \emph{c}, \emph{k} = \emph{i}, and \emph{p} = 0.5}.}
 \item{conf.level}{confidence level of the interval, and complement of the test's nominal type I error rate \mjeqn{\alpha}{alpha}.}
 \item{treatment1}{an optional string to label the first treatment group in the output (e.g., "Treated"). If unspecified, \code{tost.rrp} will create a label from the \code{x} variable's label, names, or variable name (in that order).}
 \item{treatment2}{an optional string to label the second treatment group in the output (e.g., "Untreated"). If unspecified, \code{tost.rrp} will create a label from the \code{y} variable's label, names, or variable name (in that order).}
 \item{outcome}{an optional string to label those with the outcome (e.g., "Cases"). If unspecified \code{tost.rrp} will use the label "Positive".}
 \item{nooutcome}{an optional string to label those without the outcome (e.g., "Not cases"). If unspecified \code{tost.rrp} will use the label "Negative".}
 \item{relevance}{reports results and inference for combined tests for difference and for equivalence for a specific \code{conf.level}, \code{delta0}, and, if used, \code{deltaupper}. See the Remarks section more details on inference from combined tests.}
}
\details{\code{tost.rrp} tests for equivalence of the relative risk of a positive outcome and unity in paired (or matched) randomized control trial or paired (or matched) cohort design data.  It calculates an
 asymptotic z test statistic based on a reparameterized multinomial model (Tang, et al., 2003) in a two one-sided tests approach (Schuirmann, 1987). The equivalence interval for the test is defined by a chosen level of tolerance, as specified by \code{delta0}.

The two one-sided null hypotheses take on the following form based on the relative risk (RR), and the threshold \code{delta0}:

\emph{}\mjeqn{\phantom{22}\text{H}_{01}^{-}\text{: RR} \le \delta_0\text{, or}}{Ho1: RR <= delta0, or}

\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: RR} \ge \frac{1}{\delta_0}\text{.}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: RR >= 1/delta0.}

\emph{}\mjeqn{\phantom{2222}}{&nbsp;&nbsp;}where the equivalence interval ranges from \mjeqn{\delta_0}{delta0} to \mjeqn{\frac{1}{\delta_0}}{1/delta0}.
 
When a geometrically asymmetric equivalence interval is defined using the \code{deltaupper} option the two one-sided null hypotheses become:

\emph{}\mjeqn{\phantom{22}\text{H}_{01}^{-}\text{: RR} \le \delta_0\text{, or}}{Ho1: RR <= delta0, or}

\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: RR} \ge \delta_{\text{upper}}\text{.}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: RR >= deltaupper.}

where the equivalence interval ranges from \mjeqn{\delta_0}{delta0} to \mjeqn{\delta_{\text{upper}}}{deltaupper}.

The two \emph{z} test statistics, \mjeqn{z_1}{z1} and \mjeqn{z_2}{z2}, are both constructed with rejection probabilities in the upper tails. So \mjeqn{p_1 = P(Z\ge z_1)}{p1 = P(Z >= z1)}, and \mjeqn{p_2 = P(Z\ge z_2)}{p2 = P(Z >= z2)}.

NOTES: When \mjeqn{\delta_0 = 1}{delta0 = 1}, the Tang-Tang-Chan test statistic reduces to McNemar's \mjeqn{\chi^2}{chi-sq} test statistic (McNemar, 1947). When \mjeqn{a = b = c = 0}{a = b = c = 0}, there are no positve outcomes in either treatment group, and the RR and test statistics become undefined. If \mjeqn{a > 0}{a > 0}, and \mjeqn{b = c = 0}{b = c = 0}, then there is complete concordance, and \mjeqn{z_1 = z_2}{z1 = z2}, so \mjeqn{p_1 = p_2}{p1 = p2}. As is standard with two one-sided tests for equivalence, if one wishes to make a type I error \%5 of the time, one simply conducts both of the one-sided tests of \mjeqn{\text{H}_{01}^{-}}{Ho1} and \mjeqn{\text{H}_{02}^{-}}{Ho2} by comparing the resulting p-values to 0.05 (Wellek, 2010).


\subsection{Remarks}{As described by Tryon and Lewis (2008), when rejection decisions from both tests for difference (i.e. \mjeqn{\text{H}_{0}^{+}\text{: RR}= 1}{positivist Ho+: RR = 1}) and tests for equivalence (i.e. \mjeqn{\text{H}_{01}^{-}\text{: RR} \le \delta_{0}}{negativist Ho1-: RR <= delta0}, or \mjeqn{\text{H}_{02}^{-}\text{: RR} \ge \frac{1}{\delta_0}}{negativist Ho2-: RR >= 1/delta0}) are combined, there are four possible interpretations for a given \mjeqn{\alpha}{alpha} and \mjeqn{\delta_0}{delta_0}:

\enumerate{
\item One may reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but fail to reject both \mjeqn{\text{H}_{01}^{-}\text{ and }\text{H}_{02}^{-}}{Ho1- and Ho2-}, and conclude that there is a \bold{relevant difference} between RR and 1 at least as large as the interval defined by \mjeqn{\delta_0}{delta0}.

\item One may fail to reject \mjeqn{\text{H}_{0}^{+}}{Ho+}, but reject both \mjeqn{\text{H}_{01}^{-}\text{ and }\text{H}_{02}^{-}}{Ho1- and Ho2-}, and conclude that there is \bold{equivalence} between RR and 1 within the interval defined by \mjeqn{\delta_0}{delta0}.

\item One may reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and reject both \mjeqn{\text{H}_{01}^{-}\text{ and }\text{H}_{02}^{-}}{Ho1- and Ho2-}, and conclude that there is a \bold{trivial difference} between RR and 1 which lies within the interval defined by \mjeqn{\delta_0}{delta0}.

\item One may fail to reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and fail to reject both \mjeqn{\text{H}_{01}^{-}\text{ and }\text{H}_{02}^{-}}{Ho1- and Ho2-}, and draw an \bold{indeterminate} conclusion, because the data are underpowered to detect either difference or equivalence.
}
}
}
\value{                                                                          
\code{tost.rrp} returns:
 \item{statistics}{a vector containing the value of \mjeqn{z_{1}}{z1} and \mjeqn{z_{2}}{z_2}; if \code{relevance=TRUE}; these are followed by the value of the \mjeqn{\chi^2}{\U03C7\U00B2} statistic for the postivist test for difference.}
 \item{p.values}{a vector of \emph{p} values for the \emph{z} tests, and, if \code{relevance=TRUE}, for the \mjeqn{\chi^2}{\U03C7\U00B2} test.}
 \item{estimate}{the estimated relative risk (aka incidence rate ratio) of positive outcome for treatment 2 vs. treatment 1.}
 \item{error}{the estimated standard deviation of relative risk based on the score statistic per (Tang, et al., 2003).}
 \item{threshold}{a scalar (\mjeqn{\delta_0}{\U03B4\U2080}) containing the equivalence threshold when \code{deltaupper=NA}. A vector (\mjeqn{\delta_l, \delta_u}{\U03B4l, \U03B4u}) containing the asymmetric equivalence thresholds \code{delta0}, and \code{deltaupper}.}
 \item{conclusion}{relevance test conclusion for a given \mjeqn{\alpha}{\U03B1} and \mjeqn{\delta_0}{\U03B4\U2080}, or \mjeqn{\delta_l}{\U03B4l} and \mjeqn{\delta_u}{\U03B4u}.}
 }
\author{
Alexis Dinno (\email{alexis.dinno@pdx.edu})

Please contact me with any questions, bug reports or suggestions for improvement. Fixing bugs will be facilitated by sending along:
\enumerate{
\item a copy of the data (de-labeled or anonymized is fine),\cr
\item a copy of the command syntax used, and\cr
\item a copy of the exact output of the command.\cr
}
\subsection{Suggested citation}{Dinno, A. 2025. \bold{tost.rrp}: Test for equivalence of relative risk and unity in paired binary data. In: \bold{tost.suite} R software package.}
}
\references{

Lachenbruch, P. A. and Lynch, C. J. (1998) \href{https://onlinelibrary.wiley.com/doi/abs/10.1002/(SICI)1097-0258(19981015)17:19<2207::AID-SIM920>3.0.CO;2-Y}{Assessing screening tests: Extensions of McNemar's test}. \emph{Statistics In Medicine} \bold{17}, 2207--2217.

McNemar, Q. (1947) \href{https://pubmed.ncbi.nlm.nih.gov/20254758/}{Note on the sampling error of the difference between correlated proportions or percentages}. \emph{Psychometrika} \bold{12}, 153--157
 
Schuirmann, D. A. (1987) \href{https://pubmed.ncbi.nlm.nih.gov/3450848/}{A comparison of the two one-sided tests procedure and the power approach for assessing the equivalence of average bioavailability}. \emph{Journal of Pharmacokinetics and Biopharmaceutics} \bold{15}, 657--680.

Tang, N.-S., Tang, M.-L., and Chan, I. S. F. (2003) \href{https://pubmed.ncbi.nlm.nih.gov/12687652/}{On tests of equivalence via non-unity relative risk for matched-pair design}. \emph{Statistics In Medicine} \bold{22}, 1217--1233.
 
Tryon, W. W., and C. Lewis. (2008) \href{https://pubmed.ncbi.nlm.nih.gov/18778155/}{An inferential confidence interval method of establishing statistical equivalence that corrects Tryon's (2001) reduction factor}. \emph{Psychological Methods} \bold{13}, 272--277.

Wellek, S. (2010) \href{https://www.routledge.com/Testing-Statistical-Hypotheses-of-Equivalence-and-Noninferiority/Wellek/p/book/9781439808184}{\emph{Testing Statistical Hypotheses of Equivalence and Noninferiority}}, second edition. Chapman and Hall/CRC Press. p. 31}
\seealso{
 \code{\link{mcnemar.test}}, \code{\link{tost.rrpi}}.
}
\examples{
# Setup
data(hivfluid)

# Relevance test example from Tang, et al., 2003, Table II, based on data from 
# Lachenbruch and Lynch, 1998 with equivalence interval .95 to 1.052632
#  (1/.95 = 1.052632)
tost.rrp(
  x=hivfluid$plasma, 
  y=hivfluid$alternate, 
  delta0=.95, 
  outcome="HIV Positive", 
  nooutcome="HIV Negative", 
  relevance=TRUE)
}
\keyword{htest}
\keyword{stats}
