% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_emd.R
\name{ts_fil_emd}
\alias{ts_fil_emd}
\title{EMD Filter}
\usage{
ts_fil_emd(noise = 0.1, trials = 5)
}
\arguments{
\item{noise}{noise}

\item{trials}{trials}
}
\value{
A \code{ts_fil_emd} object.
}
\description{
Empirical Mode Decomposition (EMD) filter that decomposes a
signal into intrinsic mode functions (IMFs) and reconstructs a smoothed
component.
}
\examples{
# EMD-based smoothing: remove first IMF as noise
# Load package and example data
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2 * tsd$y[9]  # inject an outlier

# Fit EMD filter and reconstruct without the first (noisiest) IMF
filter <- ts_fil_emd()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Compare original vs smoothed series
plot_ts_pred(y = tsd$y, yadj = y)
}
\references{
\itemize{
\item N. E. Huang et al. (1998). The Empirical Mode Decomposition and the
Hilbert Spectrum for nonlinear and non-stationary time series analysis.
Proceedings of the Royal Society A.
}
}
