% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{SantaFe.A}
\alias{SantaFe.A}
\title{Santa Fe Time Series Competition - Series A}
\format{
A data frame with one column and 1,100 rows, containing numeric time series values.
}
\source{
Santa Fe Time Series Competition dataset (original archive URL unavailable).
}
\usage{
data(SantaFe.A)
}
\description{
Univariate time series A from the Santa Fe Time Series Competition.
Data Type: Laser-generated nonlinear time series. Category: Benchmark. Observations: 1,100.
This benchmark dataset consists of a low-dimensional nonlinear and stationary series recorded from a Far-Infrared-Laser in a chaotic regime.
Competitors were asked to predict the last 100 observations, and performance was evaluated using NMSE.
}
\details{
Series A is a classic nonlinear laser dataset used to assess forecasting methods under chaotic dynamics.
}
\examples{
# Load Santa Fe A series and plot
data(SantaFe.A)
# SantaFe.A <- loadfulldata(SantaFe.A)
series <- SantaFe.A$V1
ts.plot(series, ylab = "Value", xlab = "Index", main = "Santa Fe A")
}
\references{
Weigend, A.S. (1993). \emph{Time Series Prediction: Forecasting the Future and Understanding the Past}. Reading, MA: Westview Press.
}
\keyword{benchmark}
\keyword{datasets}
