% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spim_consensus.R
\docType{data}
\name{spim_consensus}
\alias{spim_consensus}
\title{SPI-M-O consensus reproduction number and growth rate estimates}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 113 rows and 5 columns.
}
\source{
\url{https://www.gov.uk/guidance/the-r-value-and-growth-rate}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("spim_consensus")
}
\description{
A set of consensus estimates for the reproduction number and growth rate
of the COVID-19 epidemic in England, produced by the SPI-M-O subgroup of SAGE
}
\details{
\subsection{\code{spim_consensus_rt} dataframe with 113 rows and 5 columns}{

\describe{
\item{ \code{date} (date) }{
the date
}
\item{ \code{rt.low} (dbl) }{
the lower estimate of the reproduction number
}
\item{ \code{rt.high} (dbl) }{
the upper estimate of the reproduction number
}
\item{ \code{growth.low} (dbl) }{
the lower estimate of the exponential growth rate
}
\item{ \code{growth.high} (dbl) }{
the higher estimate of the exponential growth rate
}
}
}
}
\examples{
dplyr::glimpse(spim_consensus)
}
\concept{datasets}
\keyword{datasets}
