% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_peaklist.R
\name{as_peaklist}
\alias{as_peaklist}
\title{Check format of peaklist}
\usage{
as_peaklist(pl, verbose = FALSE, track_original_names = TRUE, ...)
}
\arguments{
\item{pl}{Input object representing a peaklist. Can be:
\itemize{
\item data.frame or data.table
\item file path to a supported tabular format
\item numeric vector of m/z values
}}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{track_original_names}{Logical (default: TRUE). If TRUE,
\code{as_peaklist()} stores a \code{"original_colnames"} attribute mapping
canonical UME names (e.g. \code{"mz"}) to the user’s original column names
(e.g. \code{"m/z"}). Internal functions that perform many \verb{:=} operations
(e.g. \code{assign_formulas()}) may set this to FALSE to avoid attribute-
related shallow-copy warnings.}

\item{...}{Reserved for future extensions.}
}
\value{
A validated and normalized peaklist as a \code{data.table}
with class \code{"ume_peaklist"}.
}
\description{
Flexible entry point for UME. Accepts:
\itemize{
\item data.frame / data.table peaklists
\item numeric m/z vectors
\item file paths (csv, txt, tsv, rds)
}

Normalizes column names, adds missing structural columns (file_id, peak_id),
removes invalid rows, validates schema, and assigns the UME peaklist class.
Creates a standardized \code{data.table} ready for formula assignment.
}
\seealso{
Other check ume objects: 
\code{\link{check_formula_library}()},
\code{\link{check_mfd}()}
}
\concept{check ume objects}
