% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{.as_peaklist_from_numeric}
\alias{.as_peaklist_from_numeric}
\title{Convert numeric m/z vector into minimal peaklist}
\usage{
.as_peaklist_from_numeric(x)
}
\arguments{
\item{x}{Numeric vector of m/z values.}
}
\value{
A minimal peaklist as a \code{data.table}.
}
\description{
Converts a simple numeric vector containing m/z values into a minimal
UME peaklist. This is useful when users want to perform direct
formula assignment on a single spectrum represented only by m/z values.

The generated peaklist contains:
\itemize{
\item \code{mz} (copied from input)
\item \code{i_magnitude} (set to 1 for all peaks)
\item \code{file_id} = 1L
}

A \code{"col_history"} attribute is added to track that the object was
constructed from a numeric vector.
}
\seealso{
Other peaklist helpers: 
\code{\link{.filter_peaklist_basic}()},
\code{\link{.load_peaklist_file}()}
}
\concept{peaklist helpers}
\keyword{internal}
