% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_colorz.R
\name{f_colorz}
\alias{f_colorz}
\title{Create Customized Color Scales}
\usage{
f_colorz(
  z,
  tf = FALSE,
  palname = "viridis",
  col_num = 100,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{z}{Numeric vector. Values whose colors should be computed.}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{palname}{Character. Name of the palette. Available palettes:
\code{"black"}, \code{"redblue"}, \code{"ratios"}, \code{"rainbow"}, \code{"awi"},
\code{"viridis"}, \code{"inferno"}, \code{"terrain.colors"}, \code{"gray"}.}

\item{col_num}{Integer. Number of colors in the palette (default: \code{100}).}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character vector of colors of the same length as \code{z}.
}
\description{
Creates color scales for numeric values using predefined color palettes.
The function supports optional log-transformation of the input values,
handles constant vectors gracefully, and maps each numeric value to a
color in the selected palette.
}
\keyword{internal}
\keyword{olor}
\keyword{palette}
