% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_freq_ma.R
\name{uplot_freq_ma}
\alias{uplot_freq_ma}
\title{Histogram of Mass Accuracy}
\usage{
uplot_freq_ma(
  mfd,
  ma_col = "ppm",
  col = "grey",
  gg_size = 12,
  logo = TRUE,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{ma_col}{Character string. Column name containing mass accuracy values.}

\item{col}{Histogram fill color.}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
ggplot2 object, or plotly object if plotly = TRUE.
}
\description{
Creates a histogram of mass accuracy values (ppm).
Includes summary statistics (median, 2.5\% and 97.5\% quantiles).
Follows general uplot behavior:
\itemize{
\item returns a ggplot2 object by default
\item converts to plotly \emph{only if} plotly = TRUE
\item uses caption-style UME logo
}
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
