% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_groups.R
\name{bitly_retrieve_group_feature_usage}
\alias{bitly_retrieve_group_feature_usage}
\title{Retrieve group's feature limit usage}
\usage{
bitly_retrieve_group_feature_usage(group_id = NA, showRequestURL = F)
}
\arguments{
\item{group_id}{- a required string | A GUID for a Bitly group}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
Get a group's current feature limit usage.
}
\examples{
\dontrun{
ui <- bitly_user_info(showRequestURL = TRUE)
rg <- bitly_retrieve_group_feature_usage(group_guid = ui$default_group_guid)
}

}
\seealso{
\url{https://dev.bitly.com/api-reference/#getGroupFeatureUsage}
}
