% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_orgs.R
\name{bitly_retrieve_org_shorten_counts_by_group}
\alias{bitly_retrieve_org_shorten_counts_by_group}
\title{Retrieve Organization Shorten Counts by Group}
\usage{
bitly_retrieve_org_shorten_counts_by_group(organization_id = NULL)
}
\arguments{
\item{organization_id}{- a required string | A GUID for a Bitly organization.
You may also simply pass "" (double quotes), but this should be avoided at all costs.}
}
\description{
Returns the shorten counts for a specific organization by group for the current month.
}
\section{Organizations}{

Organizations are part of our hierarchy. This is the top level where a group and user will belong.
}

\examples{
\dontrun{
bitly_bearerToken("access token")
all_orgs <- bitly_retrieve_orgs()
osc <- bitly_retrieve_org_shorten_counts_by_group(organization_id = all_orgs$guid)
df_org_short_counts <- data.frame(osc)
}

}
\seealso{
\url{https://dev.bitly.com/api-reference/#getOrganizationShortenCountsByGroup}
}
