% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_models.R
\name{test_mundlak_specification}
\alias{test_mundlak_specification}
\title{Test Mundlak Specification}
\usage{
test_mundlak_specification(mundlak_result)
}
\arguments{
\item{mundlak_result}{Result from fit_mundlak_cre.}
}
\value{
A list with test statistic, degrees of freedom, and p-value.
}
\description{
Performs Wald test on the sector-mean coefficient to test whether
fixed effects would be preferred over random effects.
}
\details{
Under the null hypothesis that the sector means coefficient equals zero,
random effects would be appropriate. Rejection suggests fixed effects
should be used.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2009, 5),
    sector = rep(LETTERS[1:5], each = 10),
    log_direct = rnorm(50, 5, 0.5),
    log_production = rnorm(50, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(50, 0, 0.1)

  mundlak_fit <- fit_mundlak_cre(panel)
  test_result <- test_mundlak_specification(mundlak_fit)
  print(test_result)
}
}

}
