% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{vascr_resample_time}
\alias{vascr_resample_time}
\title{Resample a vascr dataset}
\usage{
vascr_resample_time(
  data.df,
  npoints = vascr_find_count_timepoints(data.df),
  t_start = min(data.df$Time),
  t_end = max(data.df$Time),
  rate = NULL,
  force_timepoint = NULL,
  include_disc = TRUE
)
}
\arguments{
\item{data.df}{The vascr dataset to resample}

\item{npoints}{Manually specificity the number of points to resample at, default is the same frequency as the input dataset}

\item{t_start}{Time to start at}

\item{t_end}{Time to end at}

\item{rate}{Time between timepoints}

\item{force_timepoint}{Force a specific timepoint to be part of the resample}

\item{include_disc}{Add an additional data point either side of a discrepancy. Defaults TRUE}
}
\value{
An interpolated vascr dataset
}
\description{
Impedance sensing data is often not collected simultaneously, which creates issues
summarising and plotting the data. This function interpolates these data to allow
these downstream functions to happen.
}
\examples{
# Automatically re sample, mimicking the input data as closely as possible
vascr_resample_time(growth.df)

# Fully controlled resample with advanced options
vascr_resample_time(growth.df, t_start = 5, t_end = 20, rate = 5, force = c(1,2,3))

}
