% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_veh.R
\name{temp_veh}
\alias{temp_veh}
\title{Expanded Vehicles data.frame by hour}
\usage{
temp_veh(x, tfs, array = FALSE)
}
\arguments{
\item{x}{Vehicles data.frame}

\item{tfs}{temporal factor}

\item{array}{Logical, to return an array}
}
\value{
data.table
}
\description{
\code{\link{temp_veh}} multiplies
vehicles with temporal factor
}
\examples{
\dontrun{
data(net)
data(pc_profile)
x <- age_ldv(x = net$ldv)
dx <- temp_veh(x = x, tfs = pc_profile[[1]])
plot(Vehicles(as.data.frame(dx[, 1:50])))
dx2 <- temp_veh(x = x,
                tfs = pc_profile[[1]],
                array = TRUE)
plot(EmissionsArray(dx2))
}
}
\seealso{
\code{\link{temp_fact}}
}
