% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{barPlot}
\alias{barPlot}
\title{Create a bar plot visualisation from a \verb{<summarised_result>} object}
\usage{
barPlot(
  result,
  x,
  y,
  width = NULL,
  just = 0.5,
  position = "dodge",
  facet = NULL,
  colour = NULL,
  style = NULL,
  type = NULL,
  label = character()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{y}{Column or estimate name that is used as y variable.}

\item{width}{Bar width, as in \code{geom_col()} of the \code{ggplot2} package.}

\item{just}{Adjustment for column placement, as in \code{geom_col()} of the
\code{ggplot2} package.}

\item{position}{Position of bars, can be either \code{dodge} or \code{stack}}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colours.}

\item{style}{Visual theme to apply. Character, or \code{NULL}.
If a character, this may be either the name of a built-in style
(see \code{plotStyle()}), or a path to a \code{.yml} file that
defines a custom style. If \code{NULL}, the function will use the
explicit default style, unless a global style option is
set (see \code{setGlobalPlotOptions()}), or a \verb{_brand.yml} file is present
(in that order).
Refer to the package vignette on styles to learn more.}

\item{type}{Character string indicating the output plot format.
See \code{plotType()} for the list of supported plot types. If \code{type = NULL},
the function will use the global setting defined via \code{setGlobalPlotOptions()}
(if available); otherwise, a standard \code{ggplot2} plot is produced by default.}

\item{label}{Character vector with the columns to display interactively in
\code{plotly}.}
}
\value{
A plot object.
}
\description{
Create a bar plot visualisation from a \verb{<summarised_result>} object
}
\examples{
result <- mockSummarisedResult() |> dplyr::filter(variable_name == "age")

barPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  facet = c("age_group", "sex"),
  colour = "sex")

}
