% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STMF.R
\name{read_stmf_files}
\alias{read_stmf_files}
\title{Read STMF data from files downloaded from HMD}
\usage{
read_stmf_files(file)
}
\arguments{
\item{file}{Name of a file containing data downloaded from the HMD.}
}
\value{
\code{read_stmf_files} returns a \code{vital} object combining the downloaded data.
}
\description{
\code{read_stmf_files} reads weekly mortality data from a file downloaded
from the Short-term Mortality Fluctuations (STMF) series available in the
Human Mortality Database (HMD) \url{https://www.mortality.org/Data/STMF}),
and constructs a \code{vital} object suitable for use in other functions.
}
\examples{
\dontrun{
# File downloaded from the [Human Mortality Database STMF series]
(https://www.mortality.org/Data/STMF)
mortality <- read_stmf_files("AUSstmfout.csv")
}
}
\author{
Rob J Hyndman
}
\keyword{manip}
