% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_course_gradebook.R
\name{get_course_gradebook}
\alias{get_course_gradebook}
\title{Constructs the gradebook of a course.}
\usage{
get_course_gradebook(canvas, course_id)
}
\arguments{
\item{canvas}{An object containing the Canvas API key and base URL, obtained through the
\code{canvas_authenticate} function.}

\item{course_id}{The ID of the course for which to generate the gradebook.}
}
\value{
A data frame containing the gradebook with student in rows (identifiable through
\code{canvas_user_id}) and assignments in columns (identifiable through assigment names).
}
\description{
This function generates a gradebook for the assignments in a specific course in the Canvas LMS
API.
}
\details{
The gradebook shown in Canvas is not accessible through the API. Here it is reconstructed using
the (visible) assignments and students in the course. It may be useful for performing more
advanced grade calculations (like allowing for conditional extra credit) before adjusting
assignment grades (see, \code{\link{update_course_grades}} and
\code{\link{update_section_grades}}).
}
\seealso{
\code{\link[=get_assignments]{get_assignments()}}, and \code{\link[=get_assignment_submissions]{get_assignment_submissions()}}.
}
