% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_fmt_date}
\alias{whapi_fmt_date}
\title{Safe date formatting}
\usage{
whapi_fmt_date(x, fmt = "\%d/\%m/\%Y", na = "-")
}
\arguments{
\item{x}{Date or coercible to \code{Date}.}

\item{fmt}{Date format passed to \code{\link[base:format]{base::format()}}.}

\item{na}{Fallback string if the input is missing.}
}
\value{
A formatted date string, or the \code{na} placeholder if missing.
}
\description{
Formats a date safely, returning a fallback value (\code{na}) when the input
is \code{NULL} or \code{NA}.
}
\examples{
whapi_fmt_date(Sys.Date())
#> "31/08/2025"
whapi_fmt_date(NA)
#> "-"
}
