% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_get_message}
\alias{whapi_get_message}
\title{Get a WhatsApp message by ID (Whapi.Cloud)}
\usage{
whapi_get_message(
  message_id,
  resync = FALSE,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{message_id}{Character(1). The message ID to fetch.}

\item{resync}{Logical(1). Whether to resync from the device. Default FALSE.}

\item{token}{Bearer token (default from WHAPI_TOKEN env var).}

\item{timeout}{Timeout in seconds. Default 30.}

\item{verbose}{Print CLI progress? Default TRUE.}
}
\value{
Tibble with fields: id, type, subtype, chat_id, chat_name,
from, from_name, from_me, source, timestamp, timestamp_dt,
device_id, status, and raw \code{resp}.
}
\description{
Get a WhatsApp message by ID (Whapi.Cloud)
}
\examples{
\dontrun{
# Needs API Key
whapi_get_message("PsobWy36679._7w-wKmB9tMeGQ")

}
}
