% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_list}
\alias{whapi_send_list}
\title{Send a WhatsApp interactive LIST message (Whapi.Cloud)}
\usage{
whapi_send_list(
  to,
  body_text,
  list_sections,
  list_label = "Choose...",
  header_text = NULL,
  footer_text = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character(1). Phone in E.164 digits (without "+") or group id.}

\item{body_text}{Character(1). Main body text.}

\item{list_sections}{A list of sections. Each section is a named list:
\verb{list(title = <chr>, rows = list(list(id=<chr>, title=<chr>, description=<chr>?), ...))}.}

\item{list_label}{Character(1), optional. Button label that opens the list.
Default: \code{"Choose..."}}

\item{header_text, footer_text}{Character(1), optional. Header/footer texts.}

\item{token}{Bearer token. Defaults to env var \code{WHAPI_TOKEN}.}

\item{timeout}{Numeric. Request timeout in seconds. Default 30.}

\item{verbose}{Logical. Print CLI messages? Default TRUE.}
}
\value{
A tibble with \code{id}, \code{to}, \code{status}, \code{timestamp}, and the raw response in \code{resp}.
}
\description{
Sends an interactive \strong{LIST} message via Whapi.
Sections/rows are validated by \code{\link[=whapi_validate_list_sections]{whapi_validate_list_sections()}}. The payload
reuses \code{\link[=whapi_common_blocks]{whapi_common_blocks()}} to keep structure consistent across interactive
message types.
}
\examples{
\dontrun{
 Sys.setenv(WHAPI_TOKEN = "your_token_here")
 sections <- list(
   list(
     title = "Burgers",
     rows = list(
       list(id="b1", title="Plain",  description="No cheese, no sauce"),
       list(id="b2", title="Cheese", description="With melted cheese")
     )
   ),
   list(
     title = "Drinks",
     rows = list(
       list(id="d1", title="Water"),
       list(id="d2", title="Soda", description="Assorted flavors")
     )
   )
 )
 whapi_send_list(
   to = "5581999999999",
   body_text = "Choose your order:",
   list_sections = sections,
   list_label = "Open menu",
   header_text = "Our Menu",
   footer_text = "Thanks!"
 )
}
}
\seealso{
\code{\link[=whapi_validate_list_sections]{whapi_validate_list_sections()}}, \code{\link[=whapi_common_blocks]{whapi_common_blocks()}},
\code{\link[=whapi_perform_request]{whapi_perform_request()}}, \code{\link[=whapi_extract_common_fields]{whapi_extract_common_fields()}}
}
