% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFragmLoc.R
\name{plotFragmLoc}
\alias{plotFragmLoc}
\title{Plot Identified Fragments Relative To Their Location}
\usage{
plotFragmLoc(
  fraL,
  extrCol = NULL,
  useLog = FALSE,
  useCol = NULL,
  specLayout = NULL,
  useTi = NULL,
  subTit = NULL,
  footer = NULL,
  batchFig = FALSE,
  legCex = 0.5,
  legOffS = NULL,
  legBorder = NULL,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{fraL}{(list) result from \code{fragIonMass}, must conatain elements ''}

\item{extrCol}{(character) 1st should be aa seq of initial proteins (used for dimensionong graph and separating multiple input proteins), 2nd & 3rd start- and ed-site for drawing;, 4th the column to use for coloring), 5th for protein name in title of figure}

\item{useLog}{(logical) take values for coloring (4th element of  'extrCol') as log10}

\item{useCol}{(character) custom colors}

\item{specLayout}{(character) custom layout}

\item{useTi}{(character) custom title}

\item{subTit}{(character) custom sub-title}

\item{footer}{(character) custom footer}

\item{batchFig}{(logical) reduce text content for multiple figues on page}

\item{legCex}{(numeric, length=1) expansion factor}

\item{legOffS}{(numeric) legend-offset (passed to \code{\link[wrGraph]{legendHist}})}

\item{legBorder}{(logical) legend-border (passed to \code{\link[wrGraph]{legendHist}})}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
This function returns a figure
}
\description{
Take result from \code{fragIonMass} and display identified fragments by their location, an additional parameter (default logIntensity) is used for coloring
This function illustrates  the distribution of identfied peptidesa and thus common break-points.
}
\examples{
protP <- c(protP="PEPTIDE")
obsMassX <- cbind(a=c(199.1077, 296.1605, 397.2082, 510.2922,625.3192),
  b=c(227.1026, 324.1554, 425.2031, 538.2871, 653.3141),
  x=c(729.2937, 600.2511, 503.1984, 402.1507, 289.0666),
  y=c(703.3145, 574.2719, 477.2191, 376.1714, 263.0874))
rownames(obsMassX) <- c("E","P","T","I","D")      # all 1 & 7 ions not included
identP1 <- identifFixedModif(prot=protP,expMass=as.numeric(obsMassX), minFragSize=2, 
  maxFragSize=7, modTy=list(basMod=c("b","y")))     #

}
\seealso{
\code{\link{identifFixedModif}}
}
