% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{ScaleFitness}
\alias{ScaleFitness}
\title{Scaling Fitness}
\usage{
ScaleFitness(fit, k, lF)
}
\arguments{
\item{fit}{A fitness vector.}

\item{k}{Scaling exponent.}

\item{lF}{Local configuration.}
}
\value{
A scaled fitness vector.
}
\description{
Fitness is transformed by a power function 
             \code{fit^k}.
             If \code{k} is 
             \itemize{
              \item less than 1: Selection pressure is decreased.
              \item 1:  Selection pressure remains constant.
              \item larger than 1: Selection pressure is increased.
              \item 0:  Fitness is constant. Random selection.
              \item smaller than 0: Fitness is 
             \code{1/(fit^k)}.
                     }
}
\details{
Power functions are used for contrast sharpening or softening
         in image analysis. 
         For fuzzy sets representing the value of a linguistic variable,
         the power function has been used as concentration or dilation
         transformations for modeling adverbs.
}
\examples{
lF<-list()
lF$Offset<-parm(0.0001)
fit<-sample(10, 20, replace=TRUE)
fit
ScaleFitness(fit, 0.5, lF)
}
\references{
Wenstop, Fred (1980) 
         Quantitative Analysis with Linguistic Variables.
         Fuzzy Sets and Systems, 4(2), pp. 99-115.
         <doi:10.1016/0165-0114(80)90031-7>
}
\seealso{
Other Scaling: 
\code{\link{ContinuousScaleFitness}()},
\code{\link{DispersionRatio}()},
\code{\link{ScalingFitness}()},
\code{\link{ThresholdScaleFitness}()}
}
\concept{Scaling}
