% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{TransformSelect}
\alias{TransformSelect}
\title{Convert a selection function into a continuation.}
\usage{
TransformSelect(fit, lF, SelectFUN)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{SelectFUN}{Selection function.}
}
\value{
A function with a  state which consists of 
        the precomputed gene index 
        vector, its \code{length}, and a \code{counter}. 
        The function increments the counter in the state 
        of its environment and
        returns the precomputed gene index at position 
        \code{modulo((counter+1),length)} in   
        the precomputed index vector in its environment.
        The function supports the same interface as a selection function.
}
\description{
\code{TransformSelect()} precomputes 
             the indices of genes to be selected and
             converts the selection function into an access function to the 
             next index. 
             The access function provides a periodic random 
             index stream with a period length of the population size.
             In a genetic algorithm with a fixed size population,
             this avoids recomputation of the selection functions 
             for each gene 
             and its mate.
}
\details{
The motivation for this transformation is: 
          \enumerate{
          \item We avoid the recomputation of potentially 
                expensive selection functions.
                E.g. In population-based genetic algorithms, 
                the selection function
                is computed twice per generation instead of 
                more than generation times the population size. 
          \item No additional control flow is needed.
          \item Dynamic reconfiguration is possible.
          \item All selection functions have a 
                common abstract interface and, 
                therefore, can be overloaded by 
                specialized concrete implementations.
                (Polymorphism).
          } 

          The implementation idea is adapted from the
          continuation passing style 
          in functional programming. See Reynolds, J. C. (1993).
}
\section{Parallelization/Distribution}{

          \enumerate{         
          \item We use this tranformation if only the evaluation of genes 
                should be parallelized/distributed.
          \item If the complete replication of genes is parallelized, 
                this transformation cannot be used in its current form.
                The current implementations of the selection functions
                can not easily be parallelized.
                }
}

\examples{
fit<-sample(10, 15, replace=TRUE)
newselect<-TransformSelect(fit, NewlFselectGenes(), SelectSUS) 
newselect(fit, NewlFselectGenes())
newselect(fit, NewlFselectGenes(), 5)
newselect(fit, NewlFselectGenes(), 10)
newselect(fit, NewlFselectGenes(), 10)
}
\references{
Reynolds, J. C. (1993):
            The discoveries of continuations.
            \emph{LISP and Symbolic Computation} 6, 233-247. 
            <doi:10.1007/BF01019459>
}
\concept{Performance Optimization}
