% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGeneBenchmark.R
\name{selectBenchmark}
\alias{selectBenchmark}
\title{Benchmark and stress test of selection functions.}
\usage{
selectBenchmark(
  method = "Uniform",
  continuation = TRUE,
  limit = c(10, 100, 1000),
  verbose = FALSE
)
}
\arguments{
\item{method}{Selection function. Default: Uniform.}

\item{continuation}{Convert to index function? Default: TRUE.}

\item{limit}{Vector of population sizes.}

\item{verbose}{Boolean. Default: \code{FALSE}. 
If \code{TRUE}, the function benchmarked and the population size 
are printed to the console.}
}
\value{
Vector of execution times in seconds.
}
\description{
Times a selection function 
             for populations of size 10 to \eqn{10^{limit}}.
}
\examples{
selectBenchmark(method="Uniform", continuation=TRUE, limit=c(10, 100, 1000))
selectBenchmark(method="SUS", continuation=TRUE, limit=c(5000, 10000, 15000))
selectBenchmark(method="SUS", continuation=FALSE, limit=seq(from=100, to=1000, length.out=5))
}
\seealso{
Other Benchmark Selection Functions: 
\code{\link{predictSelectTime}()},
\code{\link{runOneBenchmark}()},
\code{\link{runSelectBenchmarks}()},
\code{\link{testSelectGene}()}
}
\concept{Benchmark Selection Functions}
