/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreatePhysicalArchiCmd
extends AbstractReadWriteCommand {
    private String architectureName;
    private PhysicalArchitecture physicalArchitecture;
    private LogicalFunction logicalFunction;
    private LogicalComponent logicalComponent;
    private PhysicalComponent physicalComponent;
    private LogicalArchitecture logicalArchitecture;
    private SystemEngineering systemEng;

    public CreatePhysicalArchiCmd(SystemEngineering systemEng, String architectureName, LogicalArchitecture logicalArchitecture, LogicalComponent logicalComponent, LogicalFunction logicalFunction) {
        this.architectureName = architectureName;
        this.logicalFunction = logicalFunction;
        this.logicalComponent = logicalComponent;
        this.logicalArchitecture = logicalArchitecture;
        this.systemEng = systemEng;
    }

    public void run() {
        this.physicalArchitecture = PaFactory.eINSTANCE.createPhysicalArchitecture(this.architectureName);
        PhysicalFunctionPkg physicalFunctionPkg = PaFactory.eINSTANCE.createPhysicalFunctionPkg(NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name);
        this.physicalArchitecture.setOwnedFunctionPkg((FunctionPkg)physicalFunctionPkg);
        PhysicalFunction physicalFunction = PaFactory.eINSTANCE.createPhysicalFunction(NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name);
        physicalFunctionPkg.getOwnedPhysicalFunctions().add((Object)physicalFunction);
        FunctionRealization functionRealisation = FaFactory.eINSTANCE.createFunctionRealization();
        physicalFunction.getOwnedFunctionRealizations().add((Object)functionRealisation);
        functionRealisation.setSourceElement((TraceableElement)physicalFunction);
        if (this.logicalFunction != null) {
            functionRealisation.setTargetElement((TraceableElement)this.logicalFunction);
        }
        InterfacePkg interfacesPkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        this.physicalArchitecture.setOwnedInterfacePkg(interfacesPkg);
        DataPkg dataPkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
        this.physicalArchitecture.setOwnedDataPkg(dataPkg);
        PhysicalActorPkg actorsPkg = PaFactory.eINSTANCE.createPhysicalActorPkg(NamingConstants.CreatePhysicalArchCmd_actors_pkg_name);
        this.physicalArchitecture.setOwnedPhysicalActorPkg(actorsPkg);
        this.physicalComponent = PaFactory.eINSTANCE.createPhysicalComponent(NamingConstants.CreatePhysicalArchCmd_physicalComponent_name);
        this.physicalArchitecture.setOwnedPhysicalComponent(this.physicalComponent);
        PhysicalContext physicalContext = PaFactory.eINSTANCE.createPhysicalContext(NamingConstants.CreatePhysicalArchCmd_physicalContext_name);
        this.physicalArchitecture.setOwnedPhysicalContext(physicalContext);
        Part physicalRootPart = CsFactory.eINSTANCE.createPart(this.physicalComponent.getName());
        physicalContext.getOwnedFeatures().add((Object)physicalRootPart);
        physicalRootPart.setAbstractType((AbstractType)this.physicalComponent);
        LogicalComponentRealization logicalComponentRealisation = PaFactory.eINSTANCE.createLogicalComponentRealization();
        this.physicalComponent.getOwnedLogicalComponentRealizations().add((Object)logicalComponentRealisation);
        logicalComponentRealisation.setSourceElement((TraceableElement)this.physicalComponent);
        if (this.logicalComponent != null) {
            logicalComponentRealisation.setTargetElement((TraceableElement)this.logicalComponent);
        }
        LogicalArchitectureRealization logicalArchiRealisation = PaFactory.eINSTANCE.createLogicalArchitectureRealization();
        this.physicalArchitecture.getOwnedLogicalArchitectureRealizations().add((Object)logicalArchiRealisation);
        logicalArchiRealisation.setSourceElement((TraceableElement)this.physicalArchitecture);
        if (this.logicalArchitecture != null) {
            logicalArchiRealisation.setTargetElement((TraceableElement)this.logicalArchitecture);
        }
        CapabilityRealizationPkg capaRealisationPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
        this.physicalArchitecture.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capaRealisationPkg);
        this.systemEng.getOwnedArchitectures().add((Object)this.physicalArchitecture);
    }

    public PhysicalArchitecture getPhysicalArchitecture() {
        return this.physicalArchitecture;
    }

    public PhysicalComponent getPhysicalComponent() {
        return this.physicalComponent;
    }

    public String getName() {
        return Messages.getString("capella.physical_archi.create.cmd");
    }
}

