/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.refinement.RefinementMerge;
import org.polarsys.capella.core.refinement.RefinementTargeted;
import org.polarsys.capella.core.refinement.framework.ui.SelectionWizard;
import org.polarsys.capella.core.refinement.framework.ui.model.SelectionItemNode;
import org.polarsys.capella.core.refinement.framework.ui.model.TargetSelectionItem;
import org.polarsys.capella.core.refinement.scenarios.core.ScenarioRefinement;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public class RefinementMultiple
implements IProcessor {
    private List<ScenarioRefinement> _refinements = new ArrayList<ScenarioRefinement>();

    public Iterator<ScenarioRefinement> getRefinements() {
        return this._refinements.iterator();
    }

    public RefinementMultiple(NamedElement srcElt) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        if (srcElt instanceof Scenario && ((Scenario)srcElt).getKind().equals((Object)ScenarioKind.INTERFACE)) {
            scenarios.add((Scenario)srcElt);
        } else {
            ArrayList<Scenario> scList = new ArrayList<Scenario>();
            for (EObject eObject : EObjectExt.getAll((EObject)srcElt, (EClass)InteractionPackage.Literals.SCENARIO)) {
                if (((Scenario)eObject).isMerged() || !((Scenario)eObject).getKind().equals((Object)ScenarioKind.INTERFACE)) continue;
                scList.add((Scenario)eObject);
            }
            if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)srcElt) || srcElt instanceof LogicalArchitecture) {
                NamedElement headContainer = null;
                if (srcElt instanceof LogicalComponent || srcElt instanceof LogicalArchitecture) {
                    headContainer = srcElt;
                } else {
                    headContainer = (LogicalComponent)EcoreUtil2.getFirstContainer((EObject)srcElt, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
                    if (headContainer == null) {
                        headContainer = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)srcElt, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
                    }
                }
                for (Scenario scenario : scList) {
                    if (ScenarioExt.getContainer((Scenario)scenario) != headContainer || !scenario.getKind().equals((Object)ScenarioKind.INTERFACE)) continue;
                    scenarios.add(scenario);
                }
            } else {
                scenarios.addAll(scList);
            }
        }
        if (scenarios.size() > 1) {
            ArrayList<Scenario> elts = new ArrayList<Scenario>(scenarios);
            scenarios.clear();
            String message = "Select the scenario(s) to be refined.";
            TargetSelectionItem rootItem = new TargetSelectionItem(this.groupByContainer(elts, InteractionPackage.Literals.ABSTRACT_CAPABILITY));
            SelectionWizard wizard = new SelectionWizard((SelectionItemNode)rootItem, "Capella wizard", "Scenario selection", message, true, true);
            wizard.selectAllByDefault(true);
            if (wizard.open() == 0) {
                for (SelectionItemNode item : wizard.getSelectionList()) {
                    Object data = item.getData();
                    if (data == null || scenarios.contains(data)) continue;
                    scenarios.add((Scenario)data);
                }
            }
        }
        this.fillInTargets(scenarios);
    }

    private Map<NamedElement, List<NamedElement>> groupByContainer(List<NamedElement> elts, EClass cls) {
        HashMap<NamedElement, List<NamedElement>> result = new HashMap<NamedElement, List<NamedElement>>();
        for (NamedElement elt : elts) {
            EObject container = EcoreUtil2.getFirstContainer((EObject)elt, (EClass)cls);
            if (!result.containsKey(container)) {
                ArrayList<NamedElement> lst = new ArrayList<NamedElement>();
                lst.add(elt);
                result.put((NamedElement)container, lst);
                continue;
            }
            ((List)result.get(container)).add(elt);
        }
        return result;
    }

    public Object getName() {
        return "";
    }

    public Object getResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IProcessor iProcessor : this._refinements) {
            result.add(iProcessor.getResult());
        }
        return result;
    }

    public void setContext(List<ModelElement> context) {
    }

    public void setContext(ModelElement context) {
    }

    public void setTarget(NamedElement target) {
    }

    public void execute() throws ProcessorException {
        this.execute((IProgressMonitor)new NullProgressMonitor());
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        for (IProcessor iProcessor : this._refinements) {
            iProcessor.execute(progressMonitor);
        }
    }

    private void fillInTargets(List<Scenario> srcDiagramset) {
        Map<NamedElement, List<NamedElement>> targetMap = this.evaluateTarget(srcDiagramset);
        for (NamedElement scenario : targetMap.keySet()) {
            List<NamedElement> targetList = targetMap.get(scenario);
            for (NamedElement target : targetList) {
                if (target instanceof ComponentArchitecture) {
                    if (target instanceof PhysicalArchitecture || target instanceof EPBSArchitecture) {
                        this._refinements.add(new RefinementMerge((Scenario)scenario, (ComponentArchitecture)target));
                        continue;
                    }
                    this._refinements.add(new RefinementTargeted((Scenario)scenario, (ComponentArchitecture)target));
                    continue;
                }
                if (target instanceof Component) {
                    this._refinements.add(new RefinementTargeted((Scenario)scenario, (Component)target));
                    continue;
                }
                if (!(target instanceof Part)) continue;
                this._refinements.add(new RefinementTargeted((Scenario)scenario, (Part)target));
            }
        }
    }

    protected Map<NamedElement, List<NamedElement>> evaluateTarget(List<Scenario> scenarios) {
        HashMap<NamedElement, List<NamedElement>> tmpTargets = new HashMap<NamedElement, List<NamedElement>>();
        for (Scenario scenario : scenarios) {
            ArrayList<Object> targetSet = new ArrayList<Object>();
            NamedElement diagramContainer = ScenarioExt.getContainer((Scenario)scenario);
            if (diagramContainer instanceof SystemEngineering) {
                for (LogicalArchitecture la : SystemEngineeringExt.getAllLogicalArchitecture((CapellaElement)scenario)) {
                    if (targetSet.contains(la)) continue;
                    targetSet.add(la);
                }
            } else if (diagramContainer instanceof LogicalArchitecture) {
                LogicalComponent rootLc = SystemEngineeringExt.getRootLogicalComponent((LogicalArchitecture)((LogicalArchitecture)diagramContainer));
                for (Part part : ComponentExt.getDecompositionPartInvolved((Component)rootLc)) {
                    LogicalComponent lc = (LogicalComponent)part.getAbstractType();
                    if (!ComponentExt.isComposite((Component)lc) || !ScenarioExt.contains((Scenario)scenario, (Part)part)) continue;
                    if (lc.getOwnedLogicalArchitectures().size() == 0) {
                        if (targetSet.contains(lc)) continue;
                        targetSet.add(lc);
                        continue;
                    }
                    for (LogicalArchitecture decomposition : lc.getOwnedLogicalArchitectures()) {
                        if (targetSet.contains(decomposition)) continue;
                        targetSet.add(decomposition);
                    }
                }
                PhysicalArchitecture pa = SystemEngineeringExt.getPhysicalArchitecture((CapellaElement)scenario);
                if (pa != null && !targetSet.contains(pa)) {
                    targetSet.add(pa);
                }
            } else if (diagramContainer instanceof LogicalComponent) {
                for (Part part : ComponentExt.getDecompositionPartInvolved((Component)((LogicalComponent)diagramContainer))) {
                    LogicalComponent lc = (LogicalComponent)part.getAbstractType();
                    if (!ComponentExt.isComposite((Component)lc) || !ScenarioExt.contains((Scenario)scenario, (Part)part)) continue;
                    if (lc.getOwnedLogicalArchitectures().size() == 0) {
                        if (targetSet.contains(part)) continue;
                        targetSet.add(part);
                        continue;
                    }
                    for (LogicalArchitecture decomposition : lc.getOwnedLogicalArchitectures()) {
                        if (targetSet.contains(decomposition)) continue;
                        targetSet.add(decomposition);
                    }
                }
            } else if (diagramContainer instanceof PhysicalArchitecture) {
                PhysicalComponent rootPc = SystemEngineeringExt.getRootPhysicalComponent((PhysicalArchitecture)((PhysicalArchitecture)diagramContainer));
                for (Part part : ComponentExt.getDecompositionPartInvolved((Component)rootPc)) {
                    PhysicalComponent pc = (PhysicalComponent)part.getAbstractType();
                    if (!ComponentExt.isComposite((Component)pc) || !ScenarioExt.contains((Scenario)scenario, (Part)part) || targetSet.contains(pc)) continue;
                    targetSet.add(pc);
                }
                EPBSArchitecture epbs = SystemEngineeringExt.getEPBSArchitecture((CapellaElement)scenario);
                if (epbs != null && !targetSet.contains(epbs)) {
                    targetSet.add(epbs);
                }
            } else if (diagramContainer instanceof PhysicalComponent) {
                for (Part part : ComponentExt.getDecompositionPartInvolved((Component)((PhysicalComponent)diagramContainer))) {
                    PhysicalComponent pc = (PhysicalComponent)part.getAbstractType();
                    if (!ComponentExt.isComposite((Component)pc) || !ScenarioExt.contains((Scenario)scenario, (Part)part) || targetSet.contains(part)) continue;
                    targetSet.add(part);
                }
            }
            tmpTargets.put((NamedElement)scenario, targetSet);
        }
        return this.selectTarget(tmpTargets);
    }

    protected Map<NamedElement, List<NamedElement>> selectTarget(Map<NamedElement, List<NamedElement>> allTargets) {
        HashMap<NamedElement, List<NamedElement>> finalTargets = new HashMap();
        if (!this.choiceIsNeeded(allTargets)) {
            finalTargets = allTargets;
        } else {
            TargetSelectionItem rootItem = new TargetSelectionItem(allTargets);
            String message = "Select the target(s) on which scenario refinement must be launched.";
            SelectionWizard wizard = new SelectionWizard((SelectionItemNode)rootItem, "Capella wizard", "Refinement target selection", message, true, false);
            if (wizard.open() == 0) {
                for (SelectionItemNode item : wizard.getSelectionList()) {
                    Object src = item.getSrc();
                    Object data = item.getData();
                    if (!finalTargets.containsKey(src)) {
                        finalTargets.put((NamedElement)((Scenario)src), new ArrayList());
                    }
                    if (data == null) continue;
                    ((List)finalTargets.get(src)).add((NamedElement)data);
                }
            }
        }
        return finalTargets;
    }

    private boolean choiceIsNeeded(Map<NamedElement, List<NamedElement>> allTargets) {
        for (NamedElement tgt : allTargets.keySet()) {
            if (allTargets.get(tgt).size() <= 1) continue;
            return true;
        }
        return false;
    }
}

