/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.transition.common.transposer.SharedWorkflowActivityParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;

public abstract class DefaultCommand
extends AbstractReadWriteCommand {
    protected Collection<?> selection = null;
    private IProgressMonitor progressMonitor = null;
    private SharedWorkflowActivityParameter parameters = new SharedWorkflowActivityParameter();
    protected String name;

    public SharedWorkflowActivityParameter getParameters() {
        return this.parameters;
    }

    public void addParameters(SharedWorkflowActivityParameter parameters) {
        this.parameters.merge(parameters);
    }

    public void addParameter(String idActivity, GenericParameter<?> parameter) {
        this.parameters.addParameter(idActivity, parameter);
    }

    public void addSharedParameter(GenericParameter<?> parameter) {
        this.parameters.addSharedParameter(parameter);
    }

    public DefaultCommand(Collection<?> selection) {
        this(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public DefaultCommand(Collection<?> selection, IProgressMonitor progressMonitor) {
        this.selection = selection;
        this.progressMonitor = progressMonitor;
        this.setName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void run() {
        Collection<Object> elements = this.retrieveElements(this.selection);
        IProgressMonitor monitor = this.getProgressMonitor();
        monitor.beginTask(this.getName(), 1);
        this.performTransformation(elements);
        monitor.worked(1);
    }

    protected Collection<Object> retrieveElements(Collection<?> selection) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (selection != null) {
            for (Object selectedElement : selection) {
                elements.addAll(this.retrieveRelatedElements(selectedElement));
            }
        }
        return elements;
    }

    protected abstract void performTransformation(Collection<?> var1);

    protected Collection<Object> retrieveRelatedElements(Object rootElement) {
        return Collections.singleton(rootElement);
    }
}

