/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.attachment;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.attachment.IAttachmentHandler;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultAttachmentHandler
implements IAttachmentHandler {
    @Override
    public boolean attachElementByReference(EObject sourceAttaching, EObject targetAttaching, EObject sourceAttached, EObject targetAttached, EReference sourceFeature, EReference targetFeature) {
        if (this.isApplicable(targetAttaching.eClass(), (EStructuralFeature)targetFeature)) {
            if (targetFeature.isChangeable() && !targetFeature.isDerived()) {
                if (!targetFeature.isMany()) {
                    targetAttaching.eSet((EStructuralFeature)targetFeature, (Object)targetAttached);
                } else {
                    int index;
                    boolean isAttached = false;
                    if (this.isHandlingOrdering(sourceAttaching, targetAttaching, sourceAttached, targetAttached, sourceFeature, targetFeature) && sourceAttaching != null && sourceAttached != null && this.isApplicable(sourceAttaching.eClass(), (EStructuralFeature)sourceFeature) && (index = ((EList)sourceAttaching.eGet((EStructuralFeature)sourceFeature)).indexOf((Object)sourceAttached)) != -1) {
                        EList list = (EList)targetAttaching.eGet((EStructuralFeature)targetFeature);
                        if (!targetFeature.isUnique() || !list.contains((Object)targetAttached)) {
                            list.add(Math.min(index, list.size()), (Object)targetAttached);
                        }
                        isAttached = true;
                    }
                    if (!isAttached) {
                        ((EList)targetAttaching.eGet((EStructuralFeature)targetFeature)).add((Object)targetAttached);
                    }
                }
                LogHelper.getInstance().debug(NLS.bind((String)"Element ''{0}'' attached to ''{1}'' [{2}].", (Object[])new Object[]{LogHelper.getInstance().getText(targetAttached), LogHelper.getInstance().getText(targetAttaching), targetFeature.getName()}), Messages.Activity_Transformation);
                return true;
            }
            LogHelper.getInstance().debug(NLS.bind((String)"Feature ''{0}'' of ''{1}'' is not changeable or derived.", (Object)targetFeature.getName(), (Object)((EClass)targetFeature.eContainer()).getName()), Messages.Activity_Transformation);
        } else {
            LogHelper.getInstance().warn(NLS.bind((String)"Feature ''{0}'' of ''{1}'' is not applicable on  ''{1}''.", (Object[])new Object[]{targetFeature.getName(), ((EClass)targetFeature.eContainer()).getName(), targetAttaching.eClass().getName()}), Messages.Activity_Transformation);
        }
        return false;
    }

    protected boolean isHandlingOrdering(EObject sourceAttaching, EObject targetAttaching, EObject sourceAttached, EObject targetAttached, EReference sourceFeature, EReference targetFeature) {
        return sourceFeature != null && sourceFeature.isMany() && sourceFeature.isOrdered() && targetFeature != null && targetFeature.isMany() && targetFeature.isOrdered();
    }

    @Override
    public boolean attachElementByReference(EObject element, EObject relatedElement, EReference relationship) {
        return this.attachElementByReference(null, element, null, relatedElement, null, relationship);
    }

    @Override
    @Deprecated
    public boolean attachElementByRel(EObject element, EObject relatedElement, EReference relationship) {
        return this.attachElementByReference(null, element, null, relatedElement, null, relationship);
    }

    @Override
    public boolean isApplicable(EClass clazz, EStructuralFeature feature) {
        return EcoreUtil2.isEqualOrSuperClass((EClass)feature.getEContainingClass(), (EClass)clazz);
    }

    @Override
    public void updateElementAttribute(EObject sourceElement, EObject targetElement, EAttribute feature, IContext context) {
        EAttribute attribute = feature;
        if (this.isApplicable(sourceElement.eClass(), (EStructuralFeature)attribute)) {
            Object valueSource = sourceElement.eGet((EStructuralFeature)attribute);
            if (this.isApplicable(targetElement.eClass(), (EStructuralFeature)attribute)) {
                Object valueTarget = targetElement.eGet((EStructuralFeature)attribute);
                if (attribute.isChangeable() && !attribute.isDerived()) {
                    if (this.shouldUpdateAttribute(sourceElement, targetElement, feature, valueSource, valueTarget, context)) {
                        if (valueTarget != null) {
                            LogHelper.getInstance().debug(NLS.bind((String)"Update Attribute ''{0}'' of ''{1}''.", (Object[])new Object[]{attribute.getName(), LogHelper.getInstance().getText(targetElement), LogHelper.getInstance().getText(valueTarget), LogHelper.getInstance().getText(valueSource)}), targetElement, Messages.Activity_Transformation);
                        }
                        if (!attribute.isMany()) {
                            targetElement.eSet((EStructuralFeature)attribute, valueSource);
                        } else if (valueSource instanceof EList && valueTarget instanceof EList) {
                            EList sourceList = (EList)valueSource;
                            EList targetList = (EList)valueTarget;
                            for (Object value : sourceList) {
                                targetList.add(value);
                            }
                        }
                    }
                } else {
                    LogHelper.getInstance().debug(NLS.bind((String)"Attribute ''{0}'' of ''{1}'' is not changeable or derived.", (Object[])new Object[]{attribute.getName(), LogHelper.getInstance().getText(targetElement)}), targetElement, Messages.Activity_Transformation);
                }
            }
        }
    }

    protected Collection<EObject> retrieveReferenceAsList(EObject object, EReference reference) {
        if (this.isApplicable(object.eClass(), (EStructuralFeature)reference)) {
            Object sourceReference = object.eGet((EStructuralFeature)reference);
            if (sourceReference instanceof Collection) {
                return (Collection)sourceReference;
            }
            return Collections.singleton((EObject)sourceReference);
        }
        return Collections.emptyList();
    }

    @Override
    public void attachTracedElements(EObject source, EObject target, EReference feature, IContext context) {
        for (EObject traced : this.retrieveReferenceAsList(source, feature)) {
            for (EObject related : TraceabilityHandlerHelper.getInstance(context).retrieveTracedElements(traced, context)) {
                this.attachElementByReference(source, target, traced, related, feature, feature);
            }
        }
    }

    @Override
    public void invertedAttachTracedElements(EObject source, EObject target, EReference feature, EReference targetFeature, IContext context) {
        for (EObject traced : this.retrieveReferenceAsList(source, feature)) {
            for (EObject related : TraceabilityHandlerHelper.getInstance(context).retrieveTracedElements(traced, context)) {
                this.attachElementByReference(traced, related, source, target, targetFeature, targetFeature);
            }
        }
    }

    protected boolean shouldUpdateAttribute(EObject sourceElement, EObject targetElement, EAttribute feature, Object valueSource, Object valueTarget, IContext context) {
        return valueSource == null && valueTarget != null || valueSource != null && !valueSource.equals(valueTarget);
    }

    @Override
    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public void removeElements(Collection<EObject> objects, IContext context) {
    }

    @Override
    public void createdElement(EObject element, EObject result, IContext context) {
    }
}

