/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.helper;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public class CellSelectionHelper {
    private CellSelectionHelper() {
    }

    public static List<EObject> getSelectedRowObjects(IMABodyLayer bodyLayer) {
        SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
        Set selectedCellsRowIndexes = EditUtils.getSelectedCellsForEditing((SelectionLayer)selectionLayer).stream().map(ILayerCell::getRowIndex).collect(Collectors.toSet());
        IRowDataProvider<EObject> bodyDataProvider = bodyLayer.getBodyDataProvider();
        return selectedCellsRowIndexes.stream().map(arg_0 -> bodyDataProvider.getRowObject(arg_0)).collect(Collectors.toList());
    }

    public static List<Object> getSelectedCellObjects(SelectionLayer selectionLayer) {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        Collection cells = selectionLayer.getSelectedCells();
        for (ILayerCell cell : cells) {
            Object value = cell.getDataValue();
            if (value instanceof Collection) {
                objects.addAll((Collection)value);
                continue;
            }
            objects.add(value);
        }
        return objects.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

