/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationPreferences;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ComponentPortInterfaceAdapter;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ExchangeItemUpdater;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceProvider;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceRequirer;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.PortReferenceUpdater;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.TracingStrategy;

public class InterfaceInfo {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
    public static final String DEFAULT_PROVIDER_NAME = "<provider>";
    public static final String DEFAULT_REQUIRER_NAME = "<requirer>";
    private Collection<FunctionalExchange> exchanges;
    private Interface iface;
    private boolean created;
    private final InterfaceProvider provider;
    private final InterfaceRequirer requirer;
    private TracingStrategy traceStrategy;
    private boolean errMultipleExisting;
    private boolean updated;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        result = 31 * result + (this.requirer == null ? 0 : this.requirer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceInfo other = (InterfaceInfo)obj;
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        return !(this.requirer == null ? other.requirer != null : !this.requirer.equals(other.requirer));
    }

    public InterfaceInfo(InterfaceProvider provider, InterfaceRequirer requirer, TracingStrategy strategy) {
        this.provider = provider;
        this.requirer = requirer;
        this.traceStrategy = strategy;
    }

    InterfaceProvider getProvider() {
        return this.provider;
    }

    InterfaceRequirer getRequirer() {
        return this.requirer;
    }

    public Collection<FunctionalExchange> getFunctionalExchanges() {
        if (this.exchanges == null) {
            this.exchanges = this.computeFunctionalExchanges();
        }
        return this.exchanges;
    }

    private Collection<FunctionalExchange> computeFunctionalExchanges() {
        if (this.provider == null || this.requirer == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<FunctionalExchange> providerExchanges = new LinkedHashSet<FunctionalExchange>();
        for (FunctionInputPort fip : this.provider.getFunctionInputPorts()) {
            providerExchanges.addAll(EObjectExt.getReferencers((EObject)fip, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE, (EReference)ActivityPackage.Literals.ACTIVITY_EDGE__TARGET));
        }
        ArrayList requirerExchanges = new ArrayList();
        for (FunctionOutputPort fop : this.requirer.getFunctionOutputPorts()) {
            requirerExchanges.addAll(EObjectExt.getReferencers((EObject)fop, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE, (EReference)ActivityPackage.Literals.ACTIVITY_EDGE__SOURCE));
        }
        providerExchanges.retainAll(requirerExchanges);
        return providerExchanges;
    }

    public Interface getInterface(boolean create) {
        if (this.errMultipleExisting) {
            return null;
        }
        if (this.iface == null) {
            Collection<Interface> existing = this.traceStrategy.getTracingInterfaces(this);
            if (existing.size() > 1) {
                this.errMultipleExisting = true;
                this.errorMultipleExistingInterfacesFound(existing);
            } else if (existing.size() == 1) {
                this.iface = existing.iterator().next();
            } else if (create) {
                this.created = true;
                this.iface = CsFactory.eINSTANCE.createInterface(this.initializeInterfaceName());
                BlockArchitecture ctx = BlockArchitectureExt.getRootBlockArchitecture((EObject)(this.provider == null ? this.requirer.getEObject() : this.provider.getEObject()));
                InterfacePkg pkg = ctx.getOwnedInterfacePkg();
                if (pkg == null) {
                    ctx.setOwnedInterfacePkg(CsFactory.eINSTANCE.createInterfacePkg());
                    pkg = ctx.getOwnedInterfacePkg();
                }
                pkg.getOwnedInterfaces().add((Object)this.iface);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)new EmbeddedMessage(NLS.bind((String)"Created Interface ''{0}''", (Object)EObjectLabelProviderHelper.getText((EObject)this.iface)), logger.getName(), (Object)new Object[]{this.iface}));
                }
            }
        }
        return this.iface;
    }

    private String initializeInterfaceName() {
        String name = null;
        Collection<ComponentExchange> commonExchanges = this.getComponentExchanges();
        if (this.provider == null) {
            name = String.valueOf(EObjectLabelProviderHelper.getText((EObject)this.requirer.getEObject())) + "( REQUIRER )";
        } else if (this.requirer == null) {
            name = String.valueOf(EObjectLabelProviderHelper.getText((EObject)this.provider.getEObject())) + "( PROVIDER )";
        } else if (commonExchanges.size() > 1) {
            name = this.getProviderRequirerName();
        } else if (commonExchanges.size() == 1) {
            name = commonExchanges.iterator().next().getName();
        } else if (this.getFunctionalExchanges().size() > 1) {
            name = this.getProviderRequirerName();
        } else if (this.getFunctionalExchanges().size() == 1) {
            name = this.getFunctionalExchanges().iterator().next().getName();
        }
        return name;
    }

    private String getProviderRequirerName() {
        return String.format("%s-%s", EObjectLabelProviderHelper.getText((EObject)this.provider.getEObject()), EObjectLabelProviderHelper.getText((EObject)this.requirer.getEObject()));
    }

    private void createMissingComponentExchange() {
        if (this.getComponentExchanges().isEmpty() && this.provider instanceof ComponentPortInterfaceAdapter && this.requirer instanceof ComponentPortInterfaceAdapter) {
            ComponentExchange exchange = FaFactory.eINSTANCE.createComponentExchange();
            exchange.setTarget((InformationsExchanger)((ComponentPort)this.provider.getEObject()));
            exchange.setSource((InformationsExchanger)((ComponentPort)this.requirer.getEObject()));
            exchange.setName(this.getProviderRequirerName());
            ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)exchange);
            if (logger.isInfoEnabled()) {
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)"Creating component exchange ''{0}'' between ''{1}'' and ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)exchange), EObjectLabelProviderHelper.getText((EObject)this.provider.getEObject()), EObjectLabelProviderHelper.getText((EObject)this.requirer.getEObject())}), logger.getName(), (Object)new Object[]{exchange, this.provider.getEObject(), this.requirer.getEObject()}));
            }
            for (FunctionalExchange fe : this.getFunctionalExchanges()) {
                ComponentExchangeFunctionalExchangeAllocation alloc = FaFactory.eINSTANCE.createComponentExchangeFunctionalExchangeAllocation();
                alloc.setSourceElement((TraceableElement)exchange);
                alloc.setTargetElement((TraceableElement)fe);
                exchange.getOwnedComponentExchangeFunctionalExchangeAllocations().add((Object)alloc);
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)"Allocating functional exchange ''{0}'' on ''{1}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)fe), EObjectLabelProviderHelper.getText((EObject)exchange)}), logger.getName(), (Object)new Object[]{fe, exchange}));
            }
        }
    }

    public Collection<ComponentExchange> getComponentExchanges() {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        if (this.provider != null && this.requirer != null) {
            for (ComponentExchange e : this.provider.getComponentExchanges()) {
                if (!this.requirer.getComponentExchanges().contains(e)) continue;
                result.add(e);
            }
        }
        return result;
    }

    private void errorMultipleExistingInterfacesFound(Collection<Interface> existing) {
        ArrayList<Interface> elems = new ArrayList<Interface>(existing);
        if (this.provider != null) {
            elems.add((Interface)this.provider.getEObject());
        }
        if (this.requirer != null) {
            elems.add((Interface)this.requirer.getEObject());
        }
        String providerTxt = this.provider == null ? null : "provider " + this.provider.getText();
        String requirerTxt = this.requirer == null ? null : "requirer " + this.requirer.getText();
        StringBuilder builder = new StringBuilder("Skipping generation for ");
        if (providerTxt != null) {
            builder.append(providerTxt);
            if (requirerTxt != null) {
                builder.append(" / ");
                builder.append(requirerTxt);
            }
        } else {
            builder.append(requirerTxt);
        }
        builder.append(" : Multiple candidate interfaces found");
        logger.error((Object)new EmbeddedMessage(builder.toString(), logger.getName(), elems));
    }

    public Collection<ExchangeItem> getExchangeItems(InterfaceGenerationPreferences prefs) {
        LinkedHashSet<ExchangeItem> result = new LinkedHashSet<ExchangeItem>();
        if (prefs.includeExchangeItemsFromFunctionalExchanges()) {
            for (FunctionalExchange functionalExchange : this.getFunctionalExchanges()) {
                result.addAll((Collection<ExchangeItem>)functionalExchange.getExchangedItems());
            }
        }
        if (prefs.includeExchangeItemsFromComponentExchanges()) {
            for (ComponentExchange componentExchange : this.getComponentExchanges()) {
                for (AbstractExchangeItem ei : componentExchange.getConvoyedInformations()) {
                    if (!(ei instanceof ExchangeItem)) continue;
                    result.add((ExchangeItem)ei);
                }
            }
        }
        if (this.provider == null && this.requirer != null) {
            for (FunctionOutputPort functionOutputPort : this.requirer.getFunctionOutputPorts()) {
                result.addAll((Collection<ExchangeItem>)functionOutputPort.getOutgoingExchangeItems());
            }
        }
        if (this.requirer == null && this.provider != null) {
            for (FunctionInputPort functionInputPort : this.provider.getFunctionInputPorts()) {
                result.addAll((Collection<ExchangeItem>)functionInputPort.getIncomingExchangeItems());
            }
        }
        return result;
    }

    void update(InterfaceGenerationPreferences prefs) {
        if (this.iface != null && !this.updated) {
            this.updated = true;
            this.traceStrategy.traceInterface(this.iface, this);
            ExchangeItemUpdater.updateAddMissing(this.iface, this.getExchangeItems(prefs));
            new PortReferenceUpdater(this).updatePortReferences();
            if (prefs.isGenerateComponentExchanges()) {
                this.createMissingComponentExchange();
            }
            if (prefs.isPropagateExchangeItemsToFunctionPorts()) {
                for (FunctionalExchange e : this.getFunctionalExchanges()) {
                    ExchangeItemUpdater.propagateExchangeItemsToFunctionPorts(e);
                }
            }
        }
    }

    public boolean isNew() {
        return this.created;
    }
}

