/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.validation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.AbstractValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.projection.interfaces.InterfaceGeneration;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationActivator;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationPreferences;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceGenerationResult;
import org.polarsys.capella.core.projection.interfaces.validation.Messages;

public class DWF_I_23_GenerateInterfacesValidator
extends AbstractModelConstraint {
    private static boolean loggedWorkaroundError = false;
    public static final String RULE_ID = "org.polarsys.capella.core.projection.interfaces.DWF_I_23";
    public static final String RULE_ID_UNQUALIFIED = "DWF_I_23";
    public static final int MISSING_EI_ON_INTERFACE = 0;
    public static final int UNKNOWN_EI_ON_INTERFACE = 1;

    public IStatus validate(IValidationContext ctx) {
        ComponentPort port = (ComponentPort)ctx.getTarget();
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        InterfaceGeneration gen = new InterfaceGeneration(new InterfaceGenerationPreferences(), true);
        gen.setContext((EObject)port);
        gen.execute();
        InterfaceGenerationResult result = gen.getResult();
        Collection<Interface> alreadyChecked = this.getAlreadyCheckedInterfaces(ctx);
        for (Interface iface : result.getUpdatedInterfaces()) {
            if (!alreadyChecked.add(iface)) continue;
            results.addAll(this.validate(ctx, port, iface, result));
        }
        if (results.size() > 0) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, results);
        }
        return ctx.createSuccessStatus();
    }

    private Collection<Interface> getAlreadyCheckedInterfaces(IValidationContext ctx) {
        Collection<Object> alreadyChecked;
        block12: {
            alreadyChecked = (HashSet<Interface>)ctx.getCurrentConstraintData();
            if (alreadyChecked == null) {
                AbstractValidationContext actx = (AbstractValidationContext)ctx;
                Field f = null;
                try {
                    try {
                        f = AbstractValidationContext.class.getDeclaredField("constraintData");
                        f.setAccessible(true);
                        Map map = (Map)f.get(actx);
                        for (IModelConstraint c : map.keySet()) {
                            if (c.getDescriptor().getId() != ctx.getCurrentConstraintId()) continue;
                            alreadyChecked = (Collection)map.get(c);
                            break;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        if (!loggedWorkaroundError) {
                            loggedWorkaroundError = true;
                            InterfaceGenerationActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.core.projection.interfaces", "Cannot use cache for rule DWF_I_23. Some results for this rule may appear multiple times.", (Throwable)e));
                        }
                        if (f != null) {
                            f.setAccessible(false);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (f != null) {
                        f.setAccessible(false);
                    }
                    throw throwable;
                }
                if (f != null) {
                    f.setAccessible(false);
                }
            }
        }
        if (alreadyChecked == null) {
            alreadyChecked = new HashSet<Interface>();
        }
        ctx.putCurrentConstraintData((Object)alreadyChecked);
        return alreadyChecked;
    }

    private Collection<IStatus> validate(IValidationContext ctx, ComponentPort port, Interface iface, InterfaceGenerationResult generationResult) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        for (ExchangeItem ei : generationResult.getRemovedExchangeItems(iface)) {
            ArrayList<Object> resultLocus = new ArrayList<Object>();
            resultLocus.add(ei);
            resultLocus.add(iface);
            resultLocus.add(port);
            resultLocus.addAll(generationResult.getInterfaceInfo(iface).getFunctionalExchanges());
            resultLocus.addAll(generationResult.getInterfaceInfo(iface).getComponentExchanges());
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ei, resultLocus, (int)4, (int)1, (String)Messages.DWF_I_23_GenerateInterfacesValidator_unknownEI, (Object[])new Object[]{iface, ei}));
        }
        for (ExchangeItem ei : generationResult.getAddedExchangeItems(iface)) {
            ArrayList<ComponentExchange> ce = new ArrayList<ComponentExchange>(generationResult.getInterfaceInfo(iface).getComponentExchanges());
            Iterator it = ce.iterator();
            while (it.hasNext()) {
                ComponentExchange c = (ComponentExchange)it.next();
                if (c.getConvoyedInformations().contains((Object)ei)) continue;
                it.remove();
            }
            ArrayList<FunctionalExchange> fe = new ArrayList<FunctionalExchange>(generationResult.getInterfaceInfo(iface).getFunctionalExchanges());
            Iterator it2 = fe.iterator();
            while (it2.hasNext()) {
                FunctionalExchange f = (FunctionalExchange)it2.next();
                if (f.getExchangedItems().contains((Object)ei)) continue;
                it2.remove();
            }
            ArrayList<Object> resultLocus = new ArrayList<Object>();
            resultLocus.add(ei);
            resultLocus.add(iface);
            resultLocus.add(port);
            resultLocus.addAll(generationResult.getInterfaceInfo(iface).getFunctionalExchanges());
            resultLocus.addAll(generationResult.getInterfaceInfo(iface).getComponentExchanges());
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ei, resultLocus, (int)4, (int)0, (String)Messages.DWF_I_23_GenerateInterfacesValidator_missingEI, (Object[])new Object[]{iface, ei, this.getConveyorsText(ce, fe)}));
        }
        return result;
    }

    private String[] getConveyorsText(Collection<ComponentExchange> ce, Collection<FunctionalExchange> fe) {
        String[] result = new String[ce.size() + fe.size()];
        int i = 0;
        for (ComponentExchange c : ce) {
            result[i] = String.format("\"%s\" %s", EObjectLabelProviderHelper.getText((EObject)c), Messages.DWF_I_23_GenerateInterfacesValidator_suffix_ComponentExchange);
            ++i;
        }
        for (FunctionalExchange f : fe) {
            result[i] = String.format("\"%s\" %s", EObjectLabelProviderHelper.getText((EObject)f), Messages.DWF_I_23_GenerateInterfacesValidator_suffix_FunctionalExchange);
            ++i;
        }
        return result;
    }
}

