/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.MergeHelper;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.utils.CapellaCopier;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;

public class ScenarioHelper {
    public static Scenario createScenario(Scenario sc, String name) {
        Scenario result = sc == null ? InteractionFactory.eINSTANCE.createScenario() : (Scenario)CapellaCopier.copyObject((EObject)sc, true);
        if (name != null) {
            result.setName(name);
        }
        HoldingResourceHelper.attachToHoldingResource((EObject)result, (Resource)HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)sc)));
        return result;
    }

    public static boolean hasInteractionUse(Scenario sc) throws MergeToolException {
        if (sc == null) {
            throw new MergeToolException(MergeMessages.genericToolError);
        }
        boolean result = false;
        for (TimeLapse tl : sc.getOwnedTimeLapses()) {
            if (tl.eClass() != InteractionPackage.Literals.INTERACTION_USE) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isContainedInto(Scenario sc, EObject eobject) {
        EObject container = eobject.eContainer();
        return container != null && container.equals(sc);
    }

    public static boolean isScenarioHasDecomposedElement(Scenario sc) throws MergeToolException {
        boolean result = false;
        for (InstanceRole ir : sc.getOwnedInstanceRoles()) {
            if (MergeHelper.getDecomposedIR(ir).isEmpty()) continue;
            result = true;
            break;
        }
        return result;
    }

    public static InstanceRole isPartAlreadyRepresented(Scenario sc, InstanceRole ir) {
        InstanceRole result = null;
        AbstractInstance at = ir.getRepresentedInstance();
        for (InstanceRole role : sc.getOwnedInstanceRoles()) {
            if (!role.getRepresentedInstance().equals(at)) continue;
            result = role;
            break;
        }
        return result;
    }

    public static List<Scenario> getRefinedScenarii(Scenario sc, boolean includeRoot) {
        ArrayList<Scenario> scenarii = new ArrayList<Scenario>();
        if (includeRoot) {
            scenarii.add(sc);
        }
        List<Scenario> nextLevel = ScenarioHelper.getNextLevelRefinedScenarii(sc);
        while (!nextLevel.isEmpty()) {
            scenarii.addAll(nextLevel);
            ArrayList<Scenario> list = new ArrayList<Scenario>();
            for (Scenario scenario : nextLevel) {
                list.addAll(ScenarioHelper.getNextLevelRefinedScenarii(scenario));
            }
            nextLevel.clear();
            nextLevel.addAll(list);
        }
        return scenarii;
    }

    public static List<Scenario> getNextLevelRefinedScenarii(Scenario sc) {
        ArrayList<Scenario> result = new ArrayList<Scenario>();
        result.addAll(LinkUtils.getIncomingLinkTargets((TraceableElement)sc, LinkEnum.REFINEMENT_LINK));
        return result;
    }
}

