/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.merger.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.MergeHelper;
import org.polarsys.capella.core.refinement.merge.helpers.SequenceMessageHelper;
import org.polarsys.capella.core.refinement.merge.helpers.TimeLapseHelper;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.utils.CapellaCopier;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;
import org.polarsys.capella.core.refinement.merge.utils.MergeGarbage;
import org.polarsys.capella.core.refinement.merge.utils.MergeNavigator;

public class AddElementOnScUtils {
    static AddElementOnScUtils singleton = null;
    MergeNavigator navigator = null;

    private AddElementOnScUtils() {
    }

    public static AddElementOnScUtils getInstance() {
        if (singleton == null) {
            singleton = new AddElementOnScUtils();
        }
        return singleton;
    }

    public void setNavigator(MergeNavigator navigator) {
        this.navigator = navigator;
    }

    public void addIFrag(Scenario target, InteractionFragment ifrag, boolean isNew, InteractionFragment anchor) throws MergeToolException {
        if (ifrag.eClass() == InteractionPackage.Literals.EXECUTION_END || ifrag.eClass() == InteractionPackage.Literals.MESSAGE_END) {
            if (isNew) {
                this.addAE(target, (AbstractEnd)ifrag, anchor);
            } else {
                this.replaceAE(target, (AbstractEnd)ifrag);
            }
        } else if (ifrag.eClass() == InteractionPackage.Literals.FRAGMENT_END) {
            if (isNew) {
                this.addFE(target, (FragmentEnd)ifrag, anchor);
            } else {
                this.replaceFE(target, (FragmentEnd)ifrag);
            }
        } else if (ifrag.eClass() == InteractionPackage.Literals.INTERACTION_OPERAND) {
            if (isNew) {
                this.addIO(target, (InteractionOperand)ifrag, anchor);
            } else {
                this.replaceIO(target, (InteractionOperand)ifrag);
            }
        } else if (ifrag.eClass() == InteractionPackage.Literals.INTERACTION_STATE) {
            if (isNew) {
                this.addIS(target, (InteractionState)ifrag, anchor);
            }
        } else if (ifrag.eClass() == InteractionPackage.Literals.INTERACTION_USE) {
            return;
        }
    }

    private void addIS(Scenario target, InteractionState is, InteractionFragment anchor) throws MergeToolException {
        InteractionState isSRC = is;
        InstanceRole irSRC = isSRC.getCovered();
        InteractionState isNEW = (InteractionState)CapellaCopier.copyObject((EObject)isSRC, false);
        InstanceRole irTGT = AddElementOnScUtils.getTargetIR(target, irSRC);
        isNEW.getCoveredInstanceRoles().clear();
        isNEW.getCoveredInstanceRoles().add((Object)irTGT);
        InteractionFragment anchorSRC = anchor;
        int pos = this.getPostionOnTarget(target, anchorSRC);
        target.getOwnedInteractionFragments().add(pos, (Object)isNEW);
        MergeHelper.addMergeLink((CapellaElement)isNEW, (CapellaElement)isSRC);
        TimeLapse[] tls = this.updateCreateTimeLapse((InteractionFragment)isSRC, (InteractionFragment)isNEW);
        StateFragment sfSRC = (StateFragment)tls[0];
        StateFragment sfNEW = (StateFragment)tls[1];
        sfNEW.setRelatedAbstractFunction(sfSRC.getRelatedAbstractFunction());
        sfNEW.setRelatedAbstractState(sfSRC.getRelatedAbstractState());
    }

    @Deprecated
    private void replaceIS(Scenario target, InteractionState is) throws MergeToolException {
        List<AbstractTrace> ats = this.navigator.navigateFromDataToTarget(target, (TraceableElement)is);
        int sz = ats.size();
        if (ats.isEmpty()) {
            return;
        }
        InteractionState isSRC = is;
        InstanceRole irSRC = isSRC.getCovered();
        InteractionState isTGT = (InteractionState)ats.get(--sz).getSourceElement();
        isTGT.getCoveredInstanceRoles().add((Object)AddElementOnScUtils.getTargetIR(target, irSRC));
        isTGT.setRelatedAbstractState(isSRC.getRelatedAbstractState());
        isTGT.setRelatedAbstractFunction(isSRC.getRelatedAbstractFunction());
        MergeHelper.addMergeLink((CapellaElement)isTGT, (CapellaElement)isSRC);
    }

    private void addIO(Scenario target, InteractionOperand io, InteractionFragment anchor) throws MergeToolException {
        InteractionOperand ioSRC = io;
        InteractionFragment anchorSRC = anchor;
        List<AbstractTrace> traces = null;
        ArrayList<InstanceRole> irTGTs = new ArrayList<InstanceRole>();
        InstanceRole irTGT = null;
        for (InstanceRole irSRC : ioSRC.getCoveredInstanceRoles()) {
            traces = this.navigator.navigateFromDataToTarget(target, (TraceableElement)irSRC);
            if (traces.isEmpty()) {
                irTGT = (InstanceRole)CapellaCopier.copyObject((EObject)irSRC, true);
                target.getOwnedInstanceRoles().add((Object)irTGT);
                MergeHelper.addMergeLink((CapellaElement)irTGT, (CapellaElement)irSRC);
            } else {
                irTGT = (InstanceRole)traces.get(traces.size() - 1).getSourceElement();
            }
            irTGTs.add(irTGT);
        }
        InteractionOperand ioNEW = (InteractionOperand)CapellaCopier.copyObject((EObject)ioSRC, false);
        ioNEW.getCoveredInstanceRoles().addAll(irTGTs);
        int pos = this.getPostionOnTarget(target, anchorSRC);
        target.getOwnedInteractionFragments().add(pos, (Object)ioNEW);
        MergeHelper.addMergeLink((CapellaElement)ioNEW, (CapellaElement)ioSRC);
        CombinedFragment combinedFragmentTGT = null;
        CombinedFragment combinedFragmentSRC = TimeLapseHelper.getCombinedFragment(ioSRC);
        List<AbstractTrace> list = this.navigator.navigateFromDataToTarget(target, (TraceableElement)combinedFragmentSRC);
        combinedFragmentTGT = (CombinedFragment)list.get(list.size() - 1).getSourceElement();
        combinedFragmentTGT.getReferencedOperands().add((Object)ioNEW);
    }

    private void replaceIO(Scenario target, InteractionOperand io) throws MergeToolException {
        List<AbstractTrace> ats = this.navigator.navigateFromDataToTarget(target, (TraceableElement)io);
        int sz = ats.size();
        if (ats.isEmpty()) {
            return;
        }
        InteractionOperand ioSRC = io;
        EList irSRCs = ioSRC.getCoveredInstanceRoles();
        InteractionOperand ioTGT = (InteractionOperand)ats.get(--sz).getSourceElement();
        ioTGT.getCoveredInstanceRoles().addAll(AddElementOnScUtils.getTargetIR(target, (List<InstanceRole>)irSRCs));
        MergeHelper.addMergeLink((CapellaElement)ioTGT, (CapellaElement)ioSRC);
    }

    private void addFE(Scenario target, FragmentEnd fe, InteractionFragment anchor) throws MergeToolException {
        FragmentEnd feSRC = fe;
        InteractionFragment anchorSRC = anchor;
        List<AbstractTrace> traces = null;
        ArrayList<InstanceRole> irTGTs = new ArrayList<InstanceRole>();
        InstanceRole irTGT = null;
        for (InstanceRole irSRC : fe.getCoveredInstanceRoles()) {
            traces = this.navigator.navigateFromDataToTarget(target, (TraceableElement)irSRC);
            if (traces.isEmpty()) {
                irTGT = (InstanceRole)CapellaCopier.copyObject((EObject)irSRC, true);
                target.getOwnedInstanceRoles().add((Object)irTGT);
                MergeHelper.addMergeLink((CapellaElement)irTGT, (CapellaElement)irSRC);
            } else {
                irTGT = (InstanceRole)traces.get(traces.size() - 1).getSourceElement();
            }
            irTGTs.add(irTGT);
        }
        FragmentEnd feNEW = (FragmentEnd)CapellaCopier.copyObject((EObject)feSRC, false);
        feNEW.getCoveredInstanceRoles().addAll(irTGTs);
        int pos = this.getPostionOnTarget(target, anchorSRC);
        target.getOwnedInteractionFragments().add(pos, (Object)feNEW);
        MergeHelper.addMergeLink((CapellaElement)feNEW, (CapellaElement)feSRC);
        this.updateCreateTimeLapse((InteractionFragment)feSRC, (InteractionFragment)feNEW);
    }

    private void replaceFE(Scenario target, FragmentEnd fe) throws MergeToolException {
        List<AbstractTrace> ats = this.navigator.navigateFromDataToTarget(target, (TraceableElement)fe);
        int sz = ats.size();
        if (ats.isEmpty()) {
            return;
        }
        FragmentEnd feSRC = fe;
        EList irSRCs = feSRC.getCoveredInstanceRoles();
        FragmentEnd feTGT = (FragmentEnd)ats.get(--sz).getSourceElement();
        feTGT.getCoveredInstanceRoles().addAll(AddElementOnScUtils.getTargetIR(target, (List<InstanceRole>)irSRCs));
        MergeHelper.addMergeLink((CapellaElement)feTGT, (CapellaElement)feSRC);
    }

    private void addAE(Scenario target, AbstractEnd ae, InteractionFragment anchor) throws MergeToolException {
        AbstractEnd aeSRC = ae;
        InstanceRole irSRC = ae.getCovered();
        InteractionFragment anchorSRC = anchor;
        InstanceRole irTGT = null;
        List<AbstractTrace> traces = this.navigator.navigateFromDataToTarget(target, (TraceableElement)irSRC);
        if (traces.isEmpty()) {
            irTGT = (InstanceRole)CapellaCopier.copyObject((EObject)irSRC, true);
            target.getOwnedInstanceRoles().add((Object)irTGT);
            MergeHelper.addMergeLink((CapellaElement)irTGT, (CapellaElement)irSRC);
        } else {
            irTGT = (InstanceRole)traces.get(traces.size() - 1).getSourceElement();
        }
        AbstractEnd aeNEW = (AbstractEnd)CapellaCopier.copyObject((EObject)aeSRC, false);
        aeNEW.getCoveredInstanceRoles().clear();
        aeNEW.getCoveredInstanceRoles().add((Object)irTGT);
        Event eventSRC = aeSRC.getEvent();
        Event eventNEW = (Event)CapellaCopier.copyObject((EObject)eventSRC, true);
        aeNEW.setEvent(eventNEW);
        target.getOwnedEvents().add((Object)eventNEW);
        MergeHelper.addMergeLink((CapellaElement)eventNEW, (CapellaElement)eventSRC);
        int pos = this.getPostionOnTarget(target, anchorSRC);
        target.getOwnedInteractionFragments().add(pos, (Object)aeNEW);
        MergeHelper.addMergeLink((CapellaElement)aeNEW, (CapellaElement)aeSRC);
        List<TraceableElement> list = null;
        if (aeSRC.eClass() == InteractionPackage.Literals.MESSAGE_END) {
            MessageEnd meSRC = (MessageEnd)aeSRC;
            SequenceMessage smSRC = meSRC.getMessage();
            SequenceMessage smTGT = null;
            boolean hasBeenAlreadyAdded = LinkUtils.hasIncomingLinksFrom((TraceableElement)smSRC, LinkEnum.MERGE_LINK, target);
            if (!hasBeenAlreadyAdded) {
                smTGT = (SequenceMessage)CapellaCopier.copyObject((EObject)smSRC, false);
                target.getOwnedMessages().add((Object)smTGT);
                MergeHelper.addMergeLink((CapellaElement)smTGT, (CapellaElement)smSRC);
            } else {
                list = LinkUtils.getIncomingLinkTargetsFrom((TraceableElement)smSRC, LinkEnum.MERGE_LINK, target);
                smTGT = (SequenceMessage)list.get(0);
            }
            EStructuralFeature feature = SequenceMessageHelper.returnPositionOn(smSRC, (InteractionFragment)meSRC);
            smTGT.eSet(feature, (Object)aeNEW);
        }
        this.updateCreateTimeLapse((InteractionFragment)aeSRC, (InteractionFragment)aeNEW);
    }

    private void replaceAE(Scenario target, AbstractEnd ae) throws MergeToolException {
        AbstractEnd aeORIGINATOR;
        InstanceRole irORIGINATOR;
        AbstractInstance aiORIGINATOR;
        boolean mustBeReplaced = true;
        List<AbstractTrace> ats = this.navigator.navigateFromDataToTarget(target, (TraceableElement)ae);
        int sz = ats.size();
        if (ats.isEmpty()) {
            return;
        }
        AbstractEnd aeSRC = ae;
        InstanceRole irSRC = ae.getCovered();
        AbstractInstance aiSRC = irSRC.getRepresentedInstance();
        AbstractEnd aeTGT = (AbstractEnd)ats.get(--sz).getSourceElement();
        InstanceRole irTGT = aeTGT.getCovered();
        AbstractInstance aiTGT = irTGT.getRepresentedInstance();
        boolean bl = mustBeReplaced = !aiSRC.equals(aiORIGINATOR = (irORIGINATOR = (aeORIGINATOR = (AbstractEnd)ats.get(--sz).getTargetElement()).getCovered()).getRepresentedInstance()) && aiORIGINATOR.equals(aiTGT);
        if (mustBeReplaced) {
            EStructuralFeature feature;
            AbstractEnd aeNEW = (AbstractEnd)CapellaCopier.copyObject((EObject)aeSRC, false);
            aeNEW.getCoveredInstanceRoles().clear();
            aeNEW.getCoveredInstanceRoles().add((Object)AddElementOnScUtils.getTargetIR(target, irSRC));
            Event eventSRC = aeSRC.getEvent();
            Event eventTGT = aeTGT.getEvent();
            Event eventNEW = (Event)CapellaCopier.copyObject((EObject)eventSRC, true);
            aeNEW.setEvent(eventNEW);
            target.getOwnedEvents().add((Object)eventNEW);
            MergeGarbage.INSTANCE.add((EObject)eventTGT);
            target.getOwnedEvents().remove((Object)eventTGT);
            MergeHelper.addMergeLink((CapellaElement)eventNEW, (CapellaElement)eventSRC);
            this.replaceIFrag((InteractionFragment)aeTGT, (InteractionFragment)aeNEW);
            MergeHelper.addMergeLink((CapellaElement)aeNEW, (CapellaElement)aeSRC);
            Scenario data = (Scenario)aeSRC.eContainer();
            Execution exeSRC = null;
            Execution exeTGT = null;
            TimeLapse tl = TimeLapseHelper.isAnyTimeLapseUseThisIfrag(data, (InteractionFragment)aeSRC);
            if (tl != null) {
                exeSRC = (Execution)tl;
                List<AbstractTrace> list = this.navigator.navigateFromDataToTarget(target, (TraceableElement)exeSRC);
                AbstractTrace ml = list.get(list.size() - 1);
                exeTGT = (Execution)ml.getSourceElement();
                feature = TimeLapseHelper.returnPositionOn((TimeLapse)exeSRC, (InteractionFragment)aeSRC);
                exeTGT.eSet(feature, (Object)aeNEW);
                if (!LinkUtils.doesMergeLinkAlreadyExist((TraceableElement)exeTGT, (TraceableElement)exeSRC, LinkEnum.MERGE_LINK)) {
                    MergeHelper.addMergeLink((CapellaElement)exeTGT, (CapellaElement)exeSRC);
                }
                if (!ml.getTargetElement().equals(exeSRC)) {
                    MergeGarbage.INSTANCE.add((EObject)ml);
                }
            }
            if (InteractionPackage.Literals.MESSAGE_END == aeSRC.eClass()) {
                MessageEnd meSRC = (MessageEnd)aeSRC;
                SequenceMessage smSRC = meSRC.getMessage();
                feature = SequenceMessageHelper.returnPositionOn(smSRC, (InteractionFragment)meSRC);
                SequenceMessage smTGT = null;
                MessageEnd meNEW = (MessageEnd)aeNEW;
                List<AbstractTrace> list = this.navigator.navigateFromDataToTarget(target, (TraceableElement)smSRC);
                AbstractTrace ml = list.get(list.size() - 1);
                smTGT = (SequenceMessage)ml.getSourceElement();
                if (feature == null) {
                    throw new MergeToolException(MergeMessages.genericToolError);
                }
                smTGT.eSet(feature, (Object)meNEW);
                boolean alreadyPut = false;
                for (TraceableElement tgt : LinkUtils.getOutgoingLinkTargets((TraceableElement)smTGT, LinkEnum.MERGE_LINK)) {
                    if (!tgt.equals(smSRC)) continue;
                    alreadyPut = true;
                    break;
                }
                if (!alreadyPut) {
                    MergeHelper.addMergeLink((CapellaElement)smTGT, (CapellaElement)smSRC);
                }
            }
        }
    }

    private void replaceIFrag(InteractionFragment ifragToReplace, InteractionFragment newIFrag) {
        LinkUtils.removeAllLinksOn((TraceableElement)ifragToReplace);
        Scenario sc = (Scenario)ifragToReplace.eContainer();
        int pos = sc.getOwnedInteractionFragments().indexOf((Object)ifragToReplace);
        sc.getOwnedInteractionFragments().set(pos, (Object)newIFrag);
    }

    public static List<InstanceRole> getTargetIR(Scenario target, List<InstanceRole> irs) {
        ArrayList<InstanceRole> result = new ArrayList<InstanceRole>();
        InstanceRole irToAdd = null;
        for (InstanceRole ir : irs) {
            irToAdd = AddElementOnScUtils.getTargetIR(target, ir);
            if (irToAdd == null) continue;
            result.add(irToAdd);
        }
        return result;
    }

    public static InstanceRole getTargetIR(Scenario target, InstanceRole ir) {
        InstanceRole result = null;
        InstanceRole role = null;
        for (InstanceRole irOnTGT : target.getOwnedInstanceRoles()) {
            role = (InstanceRole)LinkUtils.getOutgoingLinkTargets((TraceableElement)irOnTGT, LinkEnum.MERGE_LINK).get(0);
            if (!role.equals(ir)) continue;
            result = irOnTGT;
            break;
        }
        if (result == null) {
            AbstractInstance ai = ir.getRepresentedInstance();
            AbstractInstance aiTGT = null;
            for (InstanceRole ir2 : target.getOwnedInstanceRoles()) {
                aiTGT = ir2.getRepresentedInstance();
                if (!aiTGT.equals(ai)) continue;
                result = ir2;
                break;
            }
        }
        return result;
    }

    private int getPostionOnTarget(Scenario target, InteractionFragment anchorSRC) throws MergeToolException {
        int pos = 0;
        if (anchorSRC != null) {
            List<AbstractTrace> traces = this.navigator.navigateFromDataToTarget(target, (TraceableElement)anchorSRC);
            InteractionFragment anchorTGT = (InteractionFragment)traces.get(traces.size() - 1).getSourceElement();
            pos = target.getOwnedInteractionFragments().indexOf((Object)anchorTGT) + 1;
        }
        return pos;
    }

    private TimeLapse[] updateCreateTimeLapse(InteractionFragment ifragSRC, InteractionFragment ifragTGT) throws MergeToolException {
        TimeLapse[] tls = new TimeLapse[2];
        Scenario data = (Scenario)ifragSRC.eContainer();
        Scenario target = (Scenario)ifragTGT.eContainer();
        TimeLapse tlSRC = null;
        TimeLapse tlTGT = null;
        tlSRC = TimeLapseHelper.isAnyTimeLapseUseThisIfrag(data, ifragSRC);
        if (tlSRC != null) {
            boolean hasBeenAlreadyAdded = LinkUtils.hasIncomingLinksFrom((TraceableElement)tlSRC, LinkEnum.MERGE_LINK, target);
            if (!hasBeenAlreadyAdded) {
                tlTGT = (TimeLapse)CapellaCopier.copyObject((EObject)tlSRC, false);
                if (tlTGT.eClass() == InteractionPackage.Literals.INTERACTION_USE) {
                    InteractionUse iuSRC = (InteractionUse)tlSRC;
                    InteractionUse uiTGT = (InteractionUse)tlTGT;
                    uiTGT.setReferencedScenario(iuSRC.getReferencedScenario());
                }
                target.getOwnedTimeLapses().add((Object)tlTGT);
                MergeHelper.addMergeLink((CapellaElement)tlTGT, (CapellaElement)tlSRC);
            } else {
                List<TraceableElement> list = LinkUtils.getIncomingLinkTargetsFrom((TraceableElement)tlSRC, LinkEnum.MERGE_LINK, target);
                tlTGT = (TimeLapse)list.get(0);
            }
            EStructuralFeature feature = TimeLapseHelper.returnPositionOn(tlSRC, ifragSRC);
            tlTGT.eSet(feature, (Object)ifragTGT);
        }
        tls[0] = tlSRC;
        tls[1] = tlTGT;
        return tls;
    }
}

