/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;
import org.polarsys.capella.core.projection.exchanges.EntitiesExchangesHelper;

public class EntityExchangesCreator
extends DefaultExchangesCreator {
    public EntityExchangesCreator(Component component_p) {
        super(component_p);
    }

    @Override
    public void createExchanges() {
        ArrayList<AbstractFunction> lf = new ArrayList<AbstractFunction>();
        if (this._component instanceof Entity) {
            Entity entity = (Entity)this._component;
            Collection subComponents = ComponentExt.getAllSubUsedComponents((Component)entity);
            subComponents.add(entity);
            for (Component component : subComponents) {
                for (AbstractFunction af : component.getAllocatedFunctions()) {
                    lf.add(af);
                }
            }
            for (Component component : subComponents) {
                EList laf = component.getAllocatedFunctions();
                for (AbstractFunction abstractFunction : laf) {
                    this.handleFunction(abstractFunction, entity);
                }
            }
            this.computeRoles(entity);
        }
    }

    protected void computeRoles(Entity entity_p) {
        EList<RoleAllocation> roleAllocations = EntitiesExchangesHelper.getRoleAllocations(entity_p);
        for (RoleAllocation roleAllocation : roleAllocations) {
            EList<ActivityAllocation> activityAllocations = EntitiesExchangesHelper.getActivityAllocations(roleAllocation.getRole());
            for (ActivityAllocation activityAllocation : activityAllocations) {
                OperationalActivity activity = activityAllocation.getActivity();
                this.handleFunction((AbstractFunction)activity, entity_p);
            }
        }
    }

    protected void handleFunction(AbstractFunction function_p, Entity entity_p) {
        Entity allocationBlockAsEntity2;
        EList<Entity> implementingEntities;
        Role implementingRole;
        EList allocationBlocks;
        FunctionalExchange fe;
        for (ActivityEdge output : function_p.getOutgoing()) {
            if (!(output instanceof FunctionalExchange) || !(fe = (FunctionalExchange)output).getIncomingComponentExchangeFunctionalExchangeRealizations().isEmpty()) continue;
            AbstractFunction targetF = (AbstractFunction)fe.getTarget();
            allocationBlocks = targetF.getAllocationBlocks();
            if (allocationBlocks.size() == 0) {
                allocationBlocks = new BasicEList();
                implementingRole = EntitiesExchangesHelper.getImplementingRole(targetF);
                implementingEntities = EntitiesExchangesHelper.getImplementingEntities(implementingRole);
                for (Entity entity : implementingEntities) {
                    allocationBlocks.add((Object)entity);
                }
            }
            for (AbstractFunctionalBlock allocationBlock : allocationBlocks) {
                try {
                    allocationBlockAsEntity2 = (Entity)allocationBlock;
                    if (this.doesFunctionalExchangeAlreadyHaveACommunicationMean(fe, entity_p, allocationBlockAsEntity2)) continue;
                    this.createCommunicationMean(fe, entity_p, allocationBlockAsEntity2);
                }
                catch (ClassCastException allocationBlockAsEntity2) {
                    // empty catch block
                }
            }
        }
        for (ActivityEdge input : function_p.getIncoming()) {
            if (!(input instanceof FunctionalExchange) || !(fe = (FunctionalExchange)input).getIncomingComponentExchangeFunctionalExchangeRealizations().isEmpty()) continue;
            AbstractFunction sourceF = (AbstractFunction)fe.getSource();
            allocationBlocks = sourceF.getAllocationBlocks();
            if (allocationBlocks.size() == 0) {
                allocationBlocks = new BasicEList();
                implementingRole = EntitiesExchangesHelper.getImplementingRole(sourceF);
                implementingEntities = EntitiesExchangesHelper.getImplementingEntities(implementingRole);
                for (Entity entity : implementingEntities) {
                    allocationBlocks.add((Object)entity);
                }
            }
            for (AbstractFunctionalBlock allocationBlock : allocationBlocks) {
                try {
                    allocationBlockAsEntity2 = (Entity)allocationBlock;
                    if (this.doesFunctionalExchangeAlreadyHaveACommunicationMean(fe, allocationBlockAsEntity2, entity_p)) continue;
                    this.createCommunicationMean(fe, allocationBlockAsEntity2, entity_p);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean doesFunctionalExchangeAlreadyHaveACommunicationMean(FunctionalExchange functionalExchange_p, Entity sourceEntity_p, Entity targetEntity_p) {
        if (sourceEntity_p != null) {
            for (AbstractInformationFlow flow : sourceEntity_p.getInformationFlows()) {
                CommunicationMean communicationMean;
                if (!(flow instanceof CommunicationMean) || !(communicationMean = (CommunicationMean)flow).getAllocatedFunctionalExchanges().contains((Object)functionalExchange_p) || communicationMean.getSource() != sourceEntity_p || communicationMean.getTarget() != targetEntity_p) continue;
                return true;
            }
        }
        return false;
    }

    protected void createCommunicationMean(FunctionalExchange functionalExchange_p, Entity source_p, Entity target_p) {
        CommunicationMean ce = OaFactory.eINSTANCE.createCommunicationMean(functionalExchange_p.getName());
        ce.setSource((InformationsExchanger)source_p);
        ce.setTarget((InformationsExchanger)target_p);
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)ce);
        CapellaElementExt.creationService((EObject)ce);
        ComponentExchangeFunctionalExchangeAllocation allocation = FaFactory.eINSTANCE.createComponentExchangeFunctionalExchangeAllocation();
        ce.getOwnedComponentExchangeFunctionalExchangeAllocations().add((Object)allocation);
        allocation.setTargetElement((TraceableElement)functionalExchange_p);
        allocation.setSourceElement((TraceableElement)ce);
        CapellaElementExt.creationService((EObject)allocation);
    }
}

