/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.connection;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ComponentExchange_RealizingPortsConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentExchange) {
            ComponentExchange currentExchange = (ComponentExchange)eObj;
            Port sourceCurrent = ComponentExchangeExt.getSourcePort((ComponentExchange)currentExchange);
            Port targetCurrent = ComponentExchangeExt.getTargetPort((ComponentExchange)currentExchange);
            if (sourceCurrent != null && sourceCurrent instanceof Port && targetCurrent != null && targetCurrent instanceof Port) {
                List previousPhaseElements = RefinementLinkExt.getRelatedTargetElements((CapellaElement)((CapellaElement)eObj), (EClass)FaPackage.Literals.COMPONENT_EXCHANGE);
                for (CapellaElement element : previousPhaseElements) {
                    ComponentExchange exc = (ComponentExchange)element;
                    Port sourcePrevious = ComponentExchangeExt.getSourcePort((ComponentExchange)exc);
                    Port targetPrevious = ComponentExchangeExt.getTargetPort((ComponentExchange)exc);
                    boolean sourceValid = true;
                    boolean targetValid = true;
                    if (sourcePrevious != null && sourcePrevious instanceof Port && targetPrevious != null && targetPrevious instanceof Port) {
                        sourceValid = RefinementLinkExt.isLinkedTo((TraceableElement)((TraceableElement)sourceCurrent), (TraceableElement)((TraceableElement)sourcePrevious));
                        targetValid = RefinementLinkExt.isLinkedTo((TraceableElement)((TraceableElement)targetCurrent), (TraceableElement)((TraceableElement)targetPrevious));
                    }
                    if (!sourceValid || !targetValid) continue;
                    return ctx.createSuccessStatus();
                }
                if (previousPhaseElements.size() != 0) {
                    return this.createFailureStatus(ctx, new Object[]{currentExchange.getName()});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

