/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.projection.commands.AbstractTransitionCommand;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.ES2ISTransform;

public class ESToISCommand
extends AbstractTransitionCommand {
    public ESToISCommand(Collection<EObject> rootElements_p) {
        super(rootElements_p);
    }

    public ESToISCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        super(rootElements_p, progressMonitor_p);
    }

    @Override
    public String getName() {
        return Messages.transitionES2IS_label;
    }

    @Override
    protected Collection<EObject> retrieveModelElements(EObject modelElement_p) {
        return this.searchScenarios(modelElement_p);
    }

    @Override
    protected AbstractTransform getTransformation(EObject element_p) {
        return new ES2ISTransform();
    }

    protected Collection<EObject> searchScenarios(EObject selectedElement_p) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selectedElement_p instanceof Scenario) {
            result.add(selectedElement_p);
            return result;
        }
        TreeIterator it = selectedElement_p.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof Scenario)) continue;
            Scenario scenario = (Scenario)eObject;
            if (this.isScenarioValid(scenario)) {
                result.add((EObject)scenario);
            }
            it.prune();
        }
        return result;
    }

    protected boolean isScenarioValid(Scenario scenario_p) {
        return TransitionHelper.getService().isES2ISTransitionAvailable((EObject)scenario_p);
    }
}

