/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.projection.commands.ESToISCommand;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.FS2FSTransform;

public class FStoFSCommand
extends ESToISCommand {
    public FStoFSCommand(Collection<EObject> rootElements_p) {
        super(rootElements_p);
    }

    public FStoFSCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        super(rootElements_p, progressMonitor_p);
    }

    @Override
    public String getName() {
        if (this.rootElements != null && this.rootElements.size() > 0) {
            EObject element = (EObject)this.rootElements.iterator().next();
            if (TransitionHelper.getService().isFS2FSForOASATransitionAvailable(element)) {
                return Messages.transitionFS2FS_OAtoSA_label;
            }
            if (TransitionHelper.getService().isFS2FSForLAPATransitionAvailable(element)) {
                return Messages.transitionFS2FS_LAtoPA_label;
            }
            if (TransitionHelper.getService().isFS2FSForSALATransitionAvailable(element)) {
                return Messages.transitionFS2FS_SAtoLA_label;
            }
        }
        return Messages.transitionFS2FS_label;
    }

    @Override
    protected AbstractTransform getTransformation(EObject element_p) {
        return new FS2FSTransform();
    }

    @Override
    protected boolean isScenarioValid(Scenario scenario_p) {
        return TransitionHelper.getService().isFS2FSTransitionAvailable((EObject)scenario_p);
    }
}

