/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.projection.commands.AbstractTransitionCommand;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.interfaces.ctx2la.TransformInterfacesCtx2La;
import org.polarsys.capella.core.projection.interfaces.la2pa.TransformInterfacesLa2Pa;

public class InterfaceTransitionCommand
extends AbstractTransitionCommand {
    public InterfaceTransitionCommand(Collection<EObject> rootElements_p) {
        super(rootElements_p);
    }

    public InterfaceTransitionCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        super(rootElements_p, progressMonitor_p);
    }

    @Override
    public String getName() {
        return Messages.transitionInterface_label;
    }

    @Override
    protected Collection<EObject> retrieveModelElements(EObject modelElement_p) {
        EObject modelElement = modelElement_p;
        if (modelElement_p instanceof Part) {
            modelElement = ((Part)modelElement_p).getAbstractType();
        }
        if (modelElement instanceof Component && ((Component)modelElement_p).getOwnedInterfacePkg() != null) {
            modelElement = ((Component)modelElement).getOwnedInterfacePkg();
        }
        return Collections.singleton(modelElement);
    }

    @Override
    protected AbstractTransform getTransformation(EObject element_p) {
        if (element_p != null && element_p instanceof CapellaElement) {
            CapellaElement element = (CapellaElement)element_p;
            if (CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)element)) {
                return new TransformInterfacesLa2Pa();
            }
            if (CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)element)) {
                return new TransformInterfacesCtx2La();
            }
            if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)element)) {
                return new TransformInterfacesCtx2La();
            }
        }
        return null;
    }
}

