/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.exchanges.LinkCreatorFactory;

public class MDGenerateLinksCommand
extends AbstractReadWriteCommand {
    protected Collection<EObject> _rootElements = null;

    public MDGenerateLinksCommand(Collection<EObject> rootElements_p) {
        this._rootElements = rootElements_p;
    }

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            for (EObject rootElement : this._rootElements) {
                Component component = null;
                Part part = null;
                if (rootElement instanceof Component) {
                    component = (Component)rootElement;
                } else if (rootElement instanceof Part && (part = (Part)rootElement).getAbstractType() != null && part.getAbstractType() instanceof Component) {
                    component = (Component)part.getAbstractType();
                }
                if (component == null) continue;
                LinkCreatorFactory.createConnectionCreator((Component)component, (Part)part).createExchanges();
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
    }

    public String getName() {
        EObject element;
        if (this._rootElements != null && this._rootElements.size() > 0 && (element = this._rootElements.iterator().next()) != null) {
            if (TransitionHelper.getService().isCommunicationMeansGenerationAvailable(element)) {
                return Messages.generateCommunicationMeans_label;
            }
            if (TransitionHelper.getService().isComponentExchangesGenerationAvailable(element)) {
                return Messages.generateComponentExchanges_label;
            }
            if (TransitionHelper.getService().isPhysicalLinksGenerationAvailable(element)) {
                return Messages.generatePhysicalLinks_label;
            }
        }
        return Messages.generatePhysicalLinksComponentExchanges_label;
    }
}

