/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.richtext.page;

import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.CommonActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.services.helper.FormHelper;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.explorer.activity.ui.richtext.page.Messages;
import org.polarsys.capella.core.ui.properties.helpers.NotificationHelper;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.intf.SaveStrategy;
import org.polarsys.kitalpha.richtext.widget.factory.MDERichTextFactory;

public class CapellaDocumentationActivityExplorerPage
extends CommonActivityExplorerPage {
    private MDERichTextWidget documentationText;

    public CapellaDocumentationActivityExplorerPage() {
        this((FormEditor)ActivityExplorerManager.INSTANCE.getEditorFromSession(ActivityExplorerManager.INSTANCE.getSession()));
    }

    public CapellaDocumentationActivityExplorerPage(FormEditor editor) {
        super(editor, CapellaDocumentationActivityExplorerPage.class.getName(), Messages.CapellaDocumentationActivityExplorerPage_Title);
    }

    public void dispose() {
        super.dispose();
        if (this.documentationText != null) {
            this.documentationText.dispose();
            this.documentationText = null;
        }
    }

    protected void createDocumentationText(Composite parent) {
        this.documentationText = new MDERichTextFactory().createDefaultRichTextWidget(parent);
        this.documentationText.setSaveStrategy(new SaveStrategy(){

            public void save(final String editorText, final EObject owner, final EStructuralFeature feature) {
                if (NotificationHelper.isNotificationRequired((EObject)owner, (EStructuralFeature)feature, (String)editorText)) {
                    AbstractReadWriteCommand saveCommand = new AbstractReadWriteCommand(){

                        public void run() {
                            owner.eSet(feature, (Object)editorText);
                        }
                    };
                    TransactionHelper.getExecutionManager((EObject)CapellaDocumentationActivityExplorerPage.this.documentationText.getElement()).execute((ICommand)saveCommand);
                }
            }
        });
        this.documentationText.bind((EObject)this.getDocumentedModelElement(), (EStructuralFeature)CapellacorePackage.Literals.CAPELLA_ELEMENT__DESCRIPTION);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        IEditorInput editorInput = this.getEditorInput();
        ScrolledForm form = managedForm.getForm();
        form.setText(String.valueOf(Messages.CapellaDocumentationActivityExplorerPage_Heading_Word) + editorInput.getName());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        Composite body = form.getBody();
        body.setLayout((Layout)layout);
        Composite toolbarComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)managedForm.getToolkit(), (Composite)body, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)3, (boolean)false);
        toolbarComposite.setLayoutData((Object)new GridData(1, 128, false, false));
        this.createDocumentationText(body);
        FormHelper.adaptRecursively((FormToolkit)managedForm.getToolkit(), (Composite)body);
        managedForm.reflow(true);
    }

    protected String readDescriptionFromEditorInput() {
        return this.getDocumentedModelElement().getDescription();
    }

    protected void writeDescriptionFromEditorInput(String description) {
        this.getDocumentedModelElement().setDescription(description);
    }

    protected ModelRoot getDocumentedModelElement() {
        return (ModelRoot)this.getCapellaProject().getOwnedModelRoots().get(0);
    }

    private Project getCapellaProject() {
        return (Project)ActivityExplorerManager.INSTANCE.getRootSemanticModel();
    }

    public String getValueToSave() {
        return this.readDescriptionFromEditorInput();
    }

    public boolean isVisible() {
        boolean result = ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean(this.getId());
        if (this.predicate != null) {
            result &= this.predicate.isOk();
        }
        return result;
    }
}

